<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\Punchout\CustomerData;

use Ecomero\PunchOut\Helper\Data;
use Magento\Customer\CustomerData\SectionSourceInterface;
use Magento\Customer\Model\Session;
use Magento\Store\Model\StoreManagerInterface;

class Punchout implements SectionSourceInterface
{
    protected $data;
    protected $customerSession;
    protected $storeManager;

    public function __construct(
        Data $data,
        Session $customerSession,
        StoreManagerInterface $storeManager
    ) {
        $this->data = $data;
        $this->customerSession = $customerSession;
        $this->storeManager = $storeManager;
    }

    public function getSectionData()
    {
        $result = [];

        $storeCode = $this->storeManager->getStore()->getCode();

        $punchoutConfig = $this->customerSession->getData('punchout');
        if ($punchoutConfig) {
            if ($punchoutConfig->store === $storeCode) {
                foreach ($punchoutConfig as $key => $value) {
                    $result[$key] = $value;
                }
            }
        }

        return $result;
    }
}
