<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Test\Unit\Model;

use Ecomero\PunchOut\Helper\Data;
use Ecomero\PunchOut\Helper\OrderHelper;
use Ecomero\PunchOut\Model\SetupItemRepository;
use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\ProductRepository;
use Magento\ConfigurableProduct\Model\ResourceModel\Product\Type\Configurable;
use Magento\Quote\Model\Quote;
use Magento\Quote\Model\Quote\Item;

class OrderMessageTest extends \PHPUnit\Framework\TestCase
{
    const XML_DATA = '<?xml version="1.0" encoding="UTF-8"?>
                    <!DOCTYPE cXML SYSTEM "http://xml.cxml.org/schemas/cXML/1.2.014/cXML.dtd">
                    <cXML xml:lang="en-US" payloadID="1550180894.123483@prd356utl1.int.coupahost.com" timestamp="2019-01-01T12:34:56-08:00">
                    <Header>
                        <From>
                        <Credential domain="NetworkId">
                            <Identity>buyer_id</Identity>
                        </Credential>
                        </From>
                        <To>
                        <Credential domain="DUNS">
                            <Identity>supplier_id</Identity>
                        </Credential>
                        </To>
                        <Sender>
                        <Credential domain="NetworkId">
                            <Identity>jonkoping</Identity>
                            <SharedSecret>winter</SharedSecret>
                        </Credential>
                        <UserAgent>Coupa Procurement 1.0</UserAgent>
                        </Sender>
                    </Header>
                    <Request>
                        <OrderRequest>
                        <OrderRequestHeader orderID="C178465" orderDate="2019-01-01T12:34:56-08:00" type="new">
                            <Total>
                            <Money currency="USD">579.5</Money>
                            </Total>
                            <ShipTo>
                            <Address isoCountryCode="US" addressID="ABC">
                                <Name xml:lang="en">Acme, Inc.</Name>
                                <PostalAddress name="default">
                                <DeliverTo>DEPT: John Doe</DeliverTo>
                                <Street>Acme Headquarters</Street>
                                <Street>1600 PENNSLYVANIA AVE NW</Street>
                                <City>Onsala</City>
                                <State></State>
                                <PostalCode>20500</PostalCode>
                                <Country isoCountryCode="SE">Sweden</Country>
                                </PostalAddress>
                                <Email name="default">johndoe@example.com</Email>
                            </Address>
                            </ShipTo>
                            <BillTo>
                            <Address isoCountryCode="US" addressID="ABC">
                                <Name xml:lang="en">Acme, Inc.</Name>
                                <PostalAddress name="default">
                                <DeliverTo>Accounts Payable</DeliverTo>
                                <Street>Acme Headquarters</Street>
                                <Street>1600 PENNSLYVANIA AVE NW</Street>
                                <City>Onsala</City>
                                <State></State>
                                <PostalCode>43937</PostalCode>
                                <Country isoCountryCode="SE">Sweden</Country>
                                </PostalAddress>
                            </Address>
                            </BillTo>
                            <Shipping>
                            <Money currency="USD">0.0</Money>
                            <Description xml:lang="en-US">FOB Destination - FedEx Ground Collect - Acme pays and bears freight cost, title transfer at destination.</Description>
                            </Shipping>
                            <PaymentTerm payInNumberOfDays="30"/>
                            <Contact role="endUser">
                            <Name xml:lang="en">John Doe</Name>
                            <Email name="default">johan.lindahl@ecomero.com</Email>
                            </Contact>
                            <Extrinsic name="dept_no">0140</Extrinsic>
                            <Extrinsic name="department_name">DEPT</Extrinsic>
                        </OrderRequestHeader>
                        <ItemOut quantity="3" lineNumber="1" requestedDeliveryDate="2019-01-10">
                            <ItemID>
                            <SupplierPartID>RJB_Keps1</SupplierPartID>
                            <SupplierPartAuxiliaryID>296</SupplierPartAuxiliaryID>
                            </ItemID>
                            <ItemDetail>
                            <UnitPrice>
                                <Money currency="USD">50</Money>
                            </UnitPrice>
                            <Description xml:lang="en">Swingline 747 Stapler, Rio Red</Description>
                            <UnitOfMeasure>EA</UnitOfMeasure>
                            <Classification domain="UNSPSC">unknown</Classification>
                            <Extrinsic name="LineType">Quantity</Extrinsic>
                            </ItemDetail>
                            <Distribution>
                            <Accounting name="SUPPLIES - OFFICE">
                                <Segment type="Comp" id="056" description="Comp"/>
                                <Segment type="Div" id="010" description="Div"/>
                                <Segment type="Dept" id="0150" description="Dept"/>
                                <Segment type="Acc" id="76430" description="Acc"/>
                            </Accounting>
                            <Charge>
                                <Money currency="USD">150</Money>
                            </Charge>
                            </Distribution>
                        </ItemOut>
                        <ItemOut quantity="8" lineNumber="2" requestedDeliveryDate="2019-01-10">
                            <ItemID>
                            <SupplierPartID>RJB_Tsh1-DM</SupplierPartID>
                            <SupplierPartAuxiliaryID>357</SupplierPartAuxiliaryID>
                            </ItemID>
                            <ItemDetail>
                            <UnitPrice>
                                <Money currency="USD">429.5</Money>
                            </UnitPrice>
                            <Description xml:lang="en">iPad Wi-Fi 128GB - Space Gray</Description>
                            <UnitOfMeasure>EA</UnitOfMeasure>
                            <Classification domain="UNSPSC">unknown</Classification>
                            <Extrinsic name="LineType">Quantity</Extrinsic>
                            </ItemDetail>
                            <Distribution>
                            <Accounting name="SUPPLIES - OFFICE">
                                <Segment type="Comp" id="056" description="Comp"/>
                                <Segment type="Div" id="010" description="Div"/>
                                <Segment type="Dept" id="0150" description="Dept"/>
                                <Segment type="Acc" id="76430" description="Acc"/>
                            </Accounting>
                            <Charge>
                                <Money currency="USD">429.5</Money>
                            </Charge>
                            </Distribution>
                        </ItemOut>
                        </OrderRequest>
                    </Request>
                    </cXML>';

    /** @var \Ecomero\PunchOut\Model\Order $orderMessageClass */
    protected $orderMessageClass;

    public function setUp() : void
    {
        /** @var SetupItemRepository&\PHPUnit\Framework\MockObject\MockObject $setupItemRepositoryMock */
        $setupItemRepositoryMock = $this->getMockBuilder(SetupItemRepository::class)
                ->disableOriginalConstructor()
                ->getMock();

        /** @var OrderHelper&\PHPUnit\Framework\MockObject\MockObject $orderHelperMock */
        $orderHelperMock = $this->getMockBuilder(OrderHelper::class)
                ->disableOriginalConstructor()
                ->getMock();

        /** @var Product&\PHPUnit\Framework\MockObject\MockObject $productMock */
        $productMock = $this->getMockBuilder(Product::class)
            ->disableOriginalConstructor()
            ->getMock();

        /** @var ProductRepository&\PHPUnit\Framework\MockObject\MockObject $productRepositoryMock */
        $productRepositoryMock = $this->getMockBuilder(ProductRepository::class)
            ->setMethods(['get'])
            ->disableOriginalConstructor()
            ->getMock();
        $productRepositoryMock->method('get')->willReturn($productMock);

        /** @var Configurable&\PHPUnit\Framework\MockObject\MockObject $configurableMock */
        $configurableMock = $this->getMockBuilder(Configurable::class)
            ->disableOriginalConstructor()
            ->getMock();

        /** @var Data&\PHPUnit\Framework\MockObject\MockObject $dataMock */
        $dataMock = $this->getMockBuilder(Data::class)
            ->disableOriginalConstructor()
            ->setMethods(['getClassificationDomain', 'getClassificationCode', 'getUnitOfMeasure', 'getSenderIdentity', 'getSharedSecret'])
            ->getMock();

        $dataMock->method('getClassificationDomain')->willReturn('ABC');
        $dataMock->method('getClassificationCode')->willReturn('121212');
        $dataMock->method('getUnitOfMeasure')->willReturn('EA');
        $dataMock->method('getSenderIdentity')->willReturn('testorg');
        $dataMock->method('getSharedSecret')->willReturn('supersecret');

        $this->orderMessageClass = new \Ecomero\PunchOut\Model\OrderMessage(
            $setupItemRepositoryMock,
            $orderHelperMock,
            $productRepositoryMock,
            $configurableMock,
            $dataMock
        );
    }

    public function testCreateOrderFromCart() : void
    {
        /** @var Item&\PHPUnit\Framework\MockObject\MockObject $quoteItemMock */
        $quoteItemMock = $this->getMockBuilder(Item::class)
                ->disableOriginalConstructor()
                ->getMock();

        /** @var Quote&\PHPUnit\Framework\MockObject\MockObject $quoteMock */
        $quoteMock = $this->getMockBuilder(Quote::class)
                ->setMethods(['getAllVisibleItems'])
                ->disableOriginalConstructor()
                ->getMock();
        $quoteMock->method('getAllVisibleItems')->willReturn([$quoteItemMock]);

        $rc =  $this->orderMessageClass->createOrderFromCart($quoteMock, 'SEK', '123.payload-456', '@testCookie123');

        $xml = new \SimpleXMLElement($rc);
        $this->assertEquals($xml->Message->PunchOutOrderMessage->BuyerCookie, '@testCookie123');
        $this->assertEquals($xml['payloadID'], '123.payload-456');
        $this->assertEquals($xml->Message
                                ->PunchOutOrderMessage
                                ->PunchOutOrderMessageHeader
                                ->Total
                                ->Money['currency'], 'SEK');
        $this->assertEquals($xml->Message
                                ->PunchOutOrderMessage
                                ->PunchOutOrderMessageHeader['operationAllowed'], 'edit');
    }

    public function testProcessOrderRequest() : void
    {
        $xml = new \SimpleXMLElement(OrderMessageTest::XML_DATA);
        $rc =  $this->orderMessageClass->processOrderRequest($xml);

//        $this->assertEquals($xml->Message->PunchOutOrderMessage->BuyerCookie, '@testCookie123');
    }
}
