<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\PunchOut\Plugin\Magento\Framework\App\FrontController;

use Ecomero\PunchOut\Helper\Data;
use Magento\Customer\Model\Session;
use Magento\Framework\App\ResponseFactory;
use Magento\Store\Model\StoreManagerInterface;

class RequestPreprocessor
{
    protected $responseFactory;
    protected $storeManager;
    protected $customerSession;
    protected $data;

    public function __construct(
        StoreManagerInterface $storeManager,
        ResponseFactory $responseFactory,
        Session $customerSession,
        Data $data
    ) {
        $this->storeManager = $storeManager;
        $this->responseFactory = $responseFactory;
        $this->customerSession = $customerSession;
        $this->data = $data;
    }

    public function aroundDispatch(
        \Magento\Framework\App\FrontController $subject,
        \Closure $proceed,
        \Magento\Framework\App\RequestInterface $request
    ) {
        $punchoutSession = $this->customerSession->getData('punchout');
        if ($punchoutSession) {
            $now = new \DateTime();
            $maxSession = $this->data->getSessionTimeout();
            $lastPageAccess = $this->customerSession->getData('last_page_access');
            if ($lastPageAccess && ($now->getTimestamp() - $lastPageAccess) > $maxSession) {
                $this->customerSession->unsetData('punchout');
                $this->customerSession->logout();

                $response = $this->responseFactory->create();
                $response->setRedirect($punchoutSession->baseUrl, 302);
                $response->setNoCacheHeaders();

                return $response;
            }

            if (false === $this->data->isAllowStoreChange()
                && $this->storeManager->getStore()->getCode() != $punchoutSession->store) {
                $response = $this->responseFactory->create();
                $response->setRedirect($punchoutSession->baseUrl, 302);
                $response->setNoCacheHeaders();

                return $response;
            }

            $this->customerSession->setData('last_page_access', $now->getTimestamp());
        }
        $request->setDispatched(false);

        return $proceed($request);
    }
}
