<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Test\Unit\Model;

use Ecomero\PunchOut\Helper\Data;
use Ecomero\PunchOut\Model\Setup;
use Ecomero\PunchOut\Model\SetupRepository;

class SetupMessageTest extends \PHPUnit\Framework\TestCase
{
    protected $setupMessageClass;

    const XML_DATA = '<?xml version="1.0" encoding="UTF-8"?>
    <!DOCTYPE cXML SYSTEM "http://xml.cxml.org/schemas/cXML/1.2.041/cXML.dtd">
    <cXML payloadID="1577107986.2072@punchoutcommerce.com" timestamp="2019-12-23T13:33:06+00:00">
      <Header>
        <From>
          <Credential domain="FromNetworkId">
            <Identity>FromId</Identity>
          </Credential>
        </From>
        <To>
          <Credential domain="DUNS">
            <Identity>ToId</Identity>
          </Credential>
        </To>
        <Sender>
          <Credential domain="SenderNetworkId">
            <Identity>acme</Identity>
            <SharedSecret>mySecret</SharedSecret>
          </Credential>
          <UserAgent>PunchOutCommerce PunchOut Tester</UserAgent>
        </Sender>
      </Header>
      <Request deploymentMode="production">
        <PunchOutSetupRequest operation="create">
          <BuyerCookie>c208b7f4b1ebffcafb1c5c6563e44cc1</BuyerCookie>
          <Extrinsic name="User">jdoe12345</Extrinsic>
          <Extrinsic name="UniqueUsername">jdoe12345</Extrinsic>
          <Extrinsic name="UserId">12345</Extrinsic>
          <Extrinsic name="UserEmail">jdoe@example.com</Extrinsic>
          <Extrinsic name="UserFullName">John Doe</Extrinsic>
          <Extrinsic name="UserPrintableName">John Doe</Extrinsic>
          <Extrinsic name="FirstName">John</Extrinsic>
          <Extrinsic name="LastName">Doe</Extrinsic>
          <Extrinsic name="PhoneNumber">555-555-5555</Extrinsic>
          <BrowserFormPost>
            <URL>https://punchoutcommerce.com/tools/cxml-punchout-return</URL>
          </BrowserFormPost>
          <SupplierSetup>
            <URL>http://punchout.snojken.com/index.php/rest/default/V1/punchout</URL>
          </SupplierSetup>
          <ShipTo>
            <Address addressID="TEST-ID">
              <Name xml:lang="en">TEST-Name</Name>
              <PostalAddress>
                <Street>123 Street Address</Street>
                <City>Rockville</City>
                <State>MD</State>
                <PostalCode>20850</PostalCode>
                <Country isoCountryCode="US">US</Country>
              </PostalAddress>
            </Address>
          </ShipTo>
          <ItemOut quantity="2">
            <ItemID>
              <SupplierPartID>RJB_Tsh1-DM</SupplierPartID>
              <SupplierPartAuxiliaryID>357</SupplierPartAuxiliaryID>
            </ItemID>
          </ItemOut>
          <ItemOut quantity="3">
            <ItemID>
              <SupplierPartID>RJB_Keps1</SupplierPartID>
              <SupplierPartAuxiliaryID>296</SupplierPartAuxiliaryID>
            </ItemID>
          </ItemOut>
        </PunchOutSetupRequest>
      </Request>
    </cXML>
    ';

    public function setUp() : void
    {
        /** @var Setup&\PHPUnit\Framework\MockObject\MockObject $setupMock */
        $setupMock = $this->getMockBuilder(Setup::class)
            ->setMethods(['getTimeStamp','getHeaderSenderIdentity'])
            ->disableOriginalConstructor()
            ->getMock();

        $setupMock->method('getTimeStamp')->willReturn(new \DateTime());
        $setupMock->method('getHeaderSenderIdentity')->willReturn('acme');

        /** @var SetupRepository&\PHPUnit\Framework\MockObject\MockObject $setupRepositoryMock */
        $setupRepositoryMock = $this->getMockBuilder(SetupRepository::class)
            ->setMethods(['loadFromXml','save'])
            ->disableOriginalConstructor()
            ->getMock();

        $setupRepositoryMock->method('loadFromXml')->willReturn($setupMock);

        /** @var Data&\PHPUnit\Framework\MockObject\MockObject $dataMock */
        $dataMock = $this->getMockBuilder(Data::class)
            ->setMethods(['getSenderIdentity','getSharedSecret'])
            ->disableOriginalConstructor()
            ->getMock();

        $dataMock->method('getSenderIdentity')->willReturn('acme');
        $dataMock->method('getSharedSecret')->willReturn('mySecret');

        $this->setupMessageClass = new \Ecomero\PunchOut\Model\SetupMessage(
            $setupRepositoryMock,
            $dataMock
        );
    }

    public function testProcessSetupRequest() : void
    {
        $xml = new \SimpleXMLElement(SetupMessageTest::XML_DATA);

        $rc = $this->setupMessageClass->processSetupRequest($xml, 'https://www.acme.com');
        $this->assertEquals(200, $rc['code']);
    }
}
