<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Controller;

use Ecomero\PunchOut\Helper\Data;
use Magento\Customer\Model\Session;
use Magento\Framework\App\ActionInterface;
use Magento\Framework\App\Area;
use Magento\Framework\App\Request\Http as HttpRequest;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\Request\ValidatorInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\State as AppState;
use Magento\Framework\Controller\Result\RedirectFactory;
use Magento\Framework\Exception\LocalizedException;

class PunchoutValidator implements ValidatorInterface
{
    private $redirectFactory;
    private $appState;
    private $data;
    private $customerSession;

    public function __construct(
        RedirectFactory $redirectFactory,
        AppState $appState,
        Data $data,
        Session $customerSession
    ) {
        $this->redirectFactory = $redirectFactory;
        $this->appState = $appState;
        $this->data = $data;
        $this->customerSession = $customerSession;
    }

    private function validateRequest(
        HttpRequest $request
    ): bool {
        $isPunchout = $this->data->isEnabled('OCI') || $this->data->isEnabled('cXML') || $this->data->isEnabled('PROCEEDO');
        if ($isPunchout && $this->data->isLockedDown()) {

            // Punchout is activated for site and lockdown mode is enabled
            // Check if we have a valid session or if the /punchout route is accessed
            $pubchoutSession = $this->customerSession->getData('punchout');
            if ($request->getFrontName() !== 'punchout' && $pubchoutSession === null) {
                return false;
            }
        }
        return true;
    }

    private function createException(
    ): InvalidRequestException {
        $exception = null;
        $response = $this->redirectFactory->create()
            ->setUrl('/punchout/index/error')
            ->setHttpResponseCode(302);
        $exception = new InvalidRequestException($response);

        return $exception;
    }

    public function validate(
        RequestInterface $request,
        ActionInterface $action
    ): void {
        try {
            $areaCode = $this->appState->getAreaCode();
        } catch (LocalizedException $exception) {
            $areaCode = null;
        }
        if ($request instanceof HttpRequest
            && in_array(
                $areaCode,
                [Area::AREA_FRONTEND, Area::AREA_ADMINHTML],
                true
            )
        ) {
            $valid = $this->validateRequest($request, $action);
            if (!$valid) {
                throw $this->createException();
            }
        }
    }
}
