<?php

declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */

namespace Ecomero\PunchOut\Helper;

use Laminas\Http\Client;
use Laminas\Http\Request;

class ProceedoHelper
{
    const PROCEEDO_ENDPOINT = "https://www.proceedo.net/connect/multipart";

    protected $client;
    protected $data;
    protected $logger;

    public function __construct(
        Client $client,
        Data $data,
        Logger $logger
    ) {
        $this->client = $client;
        $this->data = $data;
        $this->logger = $logger;
    }

    public function sendRequest(
        string $payLoad
    ): void {
        try {
            $file = tmpfile();
            fwrite($file, $payLoad);
            $path = stream_get_meta_data($file)['uri'];

            $this->client->reset();
            $this->client->setUri(self::PROCEEDO_ENDPOINT);
            $this->client->setMethod(Request::METHOD_POST);
            $this->client->getRequest()->getPost()->set('username', $this->data->getProceedoUserName());
            $this->client->getRequest()->getPost()->set('password', $this->data->getProceedoPassword());
            $this->client->setFileUpload($path, 'document');

            $this->client->send();
            $response = $this->client->getResponse();
            if ($response->getStatusCode() != 200) {
                $this->logger->error('ProceedoHelper::sendRequest (status: ' . $response->getStatusCode() . ', content: ' . $response->getBody());
            }
            fclose($file);
        } catch (\Throwable $t) {
            $this->logger->error('ProceedoHelper::sendRequest ' . $t->getMessage());
        }
    }
}
