<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Test\Unit\Helper;

use Magento\Catalog\Model\Product;
use Magento\Catalog\Model\Product\Attribute\Repository as ProductAttributeRepository;
use Magento\Catalog\Model\ProductRepository;
use Magento\Quote\Model\Quote;
use Magento\Quote\Model\Quote\Item as QuoteItem;
use Magento\Quote\Model\QuoteRepository;

class QuoteHelperTest extends \PHPUnit\Framework\TestCase
{
    protected $quoteHelperClass;

    public function setUp() : void
    {
        /** @var QuoteItem&\PHPUnit\Framework\MockObject\MockObject $quoteItemMock */
        $quoteItemMock = $this->getMockBuilder(QuoteItem::class)
            ->setMethods(['load','delete'])
            ->disableOriginalConstructor()
            ->getMock();
        $quoteItemMock->method('load')->willReturn($quoteItemMock);

        /** @var Quote&\PHPUnit\Framework\MockObject\MockObject $quoteMock */
        $quoteMock = $this->getMockBuilder(Quote::class)
            ->setMethods(['getItems','addProduct'])
            ->disableOriginalConstructor()
            ->getMock();
        $quoteMock->method('getItems')->willReturn([$quoteItemMock]);

        /** @var QuoteRepository&\PHPUnit\Framework\MockObject\MockObject $quoteRepositoryMock */
        $quoteRepositoryMock = $this->getMockBuilder(QuoteRepository::class)
        ->setMethods(['get','save'])
            ->disableOriginalConstructor()
            ->getMock();
        $quoteRepositoryMock->method('get')->willReturn($quoteMock);

        /** @var Product&\PHPUnit\Framework\MockObject\MockObject $productMock */
        $productMock = $this->getMockBuilder(Product::class)
            ->setMethods(['getTypeId','getTypeInstance','getConfigurableAttributesAsArray'])
            ->disableOriginalConstructor()
            ->getMock();
        $productMock->method('getTypeId')->willReturn(\Magento\ConfigurableProduct\Model\Product\Type\Configurable::TYPE_CODE);
        $productMock->method('getTypeInstance')->willReturn($productMock);
        $productMock->method('getConfigurableAttributesAsArray')->willReturn([]);

        /** @var ProductRepository&\PHPUnit\Framework\MockObject\MockObject $productRepositoryMock */
        $productRepositoryMock = $this->getMockBuilder(ProductRepository::class)
            ->setMethods(['getById','get'])
            ->disableOriginalConstructor()
            ->getMock();
        $productRepositoryMock->method('getById')->willReturn($productMock);
        $productRepositoryMock->method('get')->willReturn($productMock);

        /** @var ProductAttributeRepository&\PHPUnit\Framework\MockObject\MockObject $productAttributeRepository */
        $productAttributeRepository = $this->getMockBuilder(ProductAttributeRepository::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->quoteHelperClass = new \Ecomero\PunchOut\Helper\QuoteHelper(
            $quoteRepositoryMock,
            $productRepositoryMock,
            $productAttributeRepository,
            $quoteItemMock
        );
    }

    public function testClearCart() : void
    {
        $rc = $this->quoteHelperClass->clearCart(1);
    }

    public function testAddCartProduct() : void
    {
        $rc = $this->quoteHelperClass->addCartProduct(1, 1, 'sku', 2.0);
    }

    public function testAddOrderProduct() : void
    {
        /** @var Quote&\PHPUnit\Framework\MockObject\MockObject $quoteMock */
        $quoteMock = $this->getMockBuilder(Quote::class)
            ->disableOriginalConstructor()
            ->getMock();

        $rc = $this->quoteHelperClass->addOrderProduct($quoteMock, 'sku', 2.0);
    }
}
