<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */

namespace Ecomero\PunchOut\Helper;

use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Model\CustomerFactory;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Quote\Model\QuoteFactory;
use Magento\Quote\Model\QuoteManagement;
use Magento\Sales\Model\Order\Email\Sender\OrderSender;
use Magento\Store\Model\StoreManagerInterface;

class OrderHelper extends AbstractHelper
{
    protected $quoteFactory;
    protected $quoteHelper;
    protected $data;
    protected $storeManager;
    protected $customerFactory;
    protected $customerRepository;
    protected $quoteManagement;
    protected $orderSender;

    public function __construct(
        Context $context,
        StoreManagerInterface $storeManager,
        CustomerFactory $customerFactory,
        CustomerRepositoryInterface $customerRepository,
        QuoteFactory $quoteFactory,
        QuoteManagement $quoteManagement,
        OrderSender $orderSender,
        QuoteHelper $quoteHelper,
        Data $data
    ) {
        $this->storeManager = $storeManager;
        $this->customerFactory = $customerFactory;
        $this->customerRepository = $customerRepository;
        $this->quoteFactory = $quoteFactory;
        $this->quoteManagement = $quoteManagement;
        $this->orderSender = $orderSender;
        $this->quoteHelper = $quoteHelper;
        $this->data = $data;
        parent::__construct($context);
    }

    public function createOrder(
        string $email,
        array $items,
        array $shippingAddress,
        array $billingAddress
    ) : \Magento\Sales\Model\Order {
        $store = $this->storeManager->getStore();
        $websiteId = $this->storeManager->getStore()->getWebsiteId();

        $customer = $this->customerFactory->create();
        $customer->setWebsiteId($websiteId);
        $customer->loadByEmail($email);

        if (!$customer->getEntityId()) {
            //If not avilable then create this customer
            $customer->setWebsiteId($websiteId)
                    ->setStore($store)
                    ->setFirstname($shippingAddress['firstname'])
                    ->setLastname($shippingAddress['lastname'])
                    ->setEmail($email)
                    ->setPassword($email);
            $customer->save();
        }

        $quote = $this->quoteFactory->create();
        $quote->setStore($store);
        $customer = $this->customerRepository->getById($customer->getId());
        $quote->assignCustomer($customer);

        foreach ($items as $item) {
            $this->quoteHelper->addOrderProduct(
                $quote,
                $item->getSupplierPartId(),
                $item->getQuantity()
            );
        }
        $quote->getBillingAddress()->addData($billingAddress);
        $quote->getShippingAddress()->addData($shippingAddress);
        $shippingAddress = $quote->getShippingAddress();
        $shippingAddress->setCollectShippingRates(true)
                        ->collectShippingRates()
                        ->setShippingMethod($this->data->getShippingMethod());

        $paymentMethod = $this->data->getPaymentMethod();
        $quote->setPaymentMethod($paymentMethod);
        $quote->setInventoryProcessed(false);
        $quote->setTotalsCollectedFlag(false);
        $quote->save();

        $quote->getPayment()->importData(['method' => $paymentMethod]);
        $quote->collectTotals()->save();
        $order = $this->quoteManagement->submit($quote);
        $this->orderSender->send($order);
        $orderId = $order->getIncrementId();

        if (!$orderId) {
            throw new \Exception('Error creating order for user ' . $email);
        }

        return $order;
    }
}
