<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Api\Data;

/**
 * PunchOut Setup Item Interface
 *
 * Represents an individual item in a PunchOut setup request
 *
 * @api
 * @since 2.0.0
 */
interface SetupItemInterface
{
    /** @var string Database column name for item ID */
    public const ITEM_ID = 'item_id';
    /** @var string Database column name for setup ID reference */
    public const SETUP_ID = 'setup_id';
    /** @var string Database column name for item quantity */
    public const QUANTITY = 'quantity';
    /** @var string Database column name for supplier product ID */
    public const SUPPLIER_PART_ID = 'supplier_part_id';
    /** @var string Database column name for auxiliary product ID */
    public const SUPPLIER_PART_AUXILIARY_ID = 'supplier_part_auxiliary_id';

    /**
     * Get parent setup ID
     *
     * @return int Parent setup record ID
     * @since 2.0.0
     */
    public function getSetupId() : int;

    /**
     * Set parent setup ID
     *
     * @param int $id Setup record ID
     * @return void
     * @since 2.0.0
     */
    public function setSetupId(int $id) : void;

    /**
     * Get item quantity
     *
     * @return float Requested quantity
     * @since 2.0.0
     */
    public function getQuantity() : float;

    /**
     * Set item quantity
     *
     * @param float $qty Quantity value
     * @return void
     * @since 2.0.0
     */
    public function setQuantity(float $qty) : void;

    /**
     * Get supplier part ID
     *
     * @return string Primary product identifier (SKU)
     * @since 2.0.0
     */
    public function getSupplierPartId() : string;

    /**
     * Set supplier part ID
     *
     * @param string $partId Product identifier
     * @return void
     * @since 2.0.0
     */
    public function setSupplierPartId(string $partId) : void;

    /**
     * Get auxiliary part ID
     *
     * @return string Secondary product identifier (if applicable)
     * @since 2.0.0
     */
    public function getSupplierPartAuxiliaryId() : string;

    /**
     * Set auxiliary part ID
     *
     * @param string $partId Auxiliary product identifier
     * @return void
     * @since 2.0.0
     */
    public function setSupplierPartAuxiliaryId(string $partId) : void;
}
