<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Block\Proceedo;

use Ecomero\PunchOut\Api\SetupRepositoryInterface;
use Ecomero\PunchOut\Helper\Data;
use Ecomero\PunchOut\Helper\QuoteHelper;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Customer\Api\AccountManagementInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Model\CustomerFactory;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\View\Element\Template\Context;
use Magento\Store\Model\StoreManagerInterface;

class Login extends \Magento\Framework\View\Element\Template
{
    public function __construct(
        Context $context,
        protected SetupRepositoryInterface $repository,
        protected CustomerSession $customerSession,
        protected CheckoutSession $checkoutSession,
        protected CustomerRepositoryInterface $customerRepo,
        protected CustomerFactory $customerFactory,
        protected QuoteHelper $quoteHelper,
        protected AccountManagementInterface $customerAccountManagement,
        protected Data $settings,
        protected StoreManagerInterface $storeManager,
        array $data = []
    ) {
        parent::__construct($context, $data);
    }

    private function getParam(string $paramName) : string
    {
        $value = $this->getRequest()->getParam($paramName);
        if (empty($value)) {
            throw new \Exception("Parameter {$paramName} is missing");
        }
        return $value;
    }

    public function loginUser() : string
    {
        $rc = 'Login message not recognized';
        $this->customerSession->logout();

        try {
            $username = $this->getParam('username');
            $password = $this->getParam('password');
            $buyercookie = $this->getParam('buyercookie');
            $prosupplierid = $this->getParam('prosupplierid');
            $prosuppliername = $this->getParam('prosuppliername');
            $submiturl = $this->getParam('submiturl');
        } catch (\Throwable $t) {
            return "Login message not recognized, {$t->getMessage()}";
        }

        try {
            $this->customerAccountManagement->authenticate($username, $password);
            try {
                $customer = $this->customerRepo->get($username);
                $customer = $this->customerFactory->create()->load($customer->getId());
            } catch (\Exception $exception) {
                return 'No user found for ' . $username;
            }

            $this->customerSession->setCustomerAsLoggedIn($customer);
            $this->customerSession->setData(
                'punchout',
                (object) [  'type' => 'proceedo',
                            'store' => $this->storeManager->getStore()->getCode(),
                            'baseUrl' => $this->getBaseUrl(),
                            'hookUrl' => $submiturl,
                            'cookie' => $buyercookie,
                            'prosupplierid' => $prosupplierid,
                            'prosuppliername' => $prosuppliername
                            ]
            );
            $rc = 'OK';
        } catch (\Magento\Framework\Exception\EmailNotConfirmedException $e) {
            $rc = $e->getMessage();
            $this->_logger->error($e->getMessage());
        } catch (\Magento\Framework\Exception\State\UserLockedException $e) {
            $rc = $e->getMessage();
            $this->_logger->error($e->getMessage());
        } catch (\Magento\Framework\Exception\AuthenticationException $e) {
            $rc = $e->getMessage();
            $this->_logger->error($e->getMessage());
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            $rc = $e->getMessage();
            $this->_logger->error($e->getMessage());
        } catch (\Throwable $t) {
            $rc = 'Login failed';
            $this->_logger->critical($t);
        }

        return $rc;
    }
}
