<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Controller\Proceedo;

use Ecomero\PunchOut\Helper\Data;
use Ecomero\PunchOut\Helper\Logger;
use Ecomero\PunchOut\Model\OrderMessage;
use Ecomero\PunchOut\Model\PingMessage;
use Ecomero\PunchOut\Model\ProfileMessage;
use Ecomero\PunchOut\Model\SetupMessage;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\ActionInterface;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Result\PageFactory;
use Magento\Store\Model\StoreManagerInterface;

class Login implements HttpPostActionInterface, HttpGetActionInterface, CsrfAwareActionInterface
{
    public function __construct(
        protected UrlInterface $urlBuilder,
        protected RequestInterface $request,
        protected RawFactory $resultRawFactory,
        protected PageFactory $resultPageFactory,
        protected StoreManagerInterface $storeManager,
        protected OrderMessage $orderMessage,
        protected SetupMessage $setupMessage,
        protected ProfileMessage $profileMessage,
        protected PingMessage $pingMessage,
        protected Logger $logger,
        protected Data $data
    ) {
    }

    public function createCsrfValidationException(RequestInterface $request): ? InvalidRequestException
    {
        return null;
    }

    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }

    public function execute()
    {
        $result = $this->resultRawFactory->create();

        $result->setHeader('Cache-Control', 'no-cache', true);
        $result->setHeader('Content-Type', 'text/xml', true);
        $result->setHeader('Access-Control-Allow-Headers', '*', true);
        $result->setHeader('Access-Control-Allow-Origin', '*', true);

        try {
            if ($this->data->isEnabled('NO', Data::SCOPE_TYPE_STORE)) {
                $this->logger->error('ERROR: PunchOut is not enabled for this site');
                $result->setContents('PunchOut is not enabled for this site');
                $result->setStatusHeader(500);
            } elseif ($this->data->isEnabled('PROCEEDO', Data::SCOPE_TYPE_STORE)) {
                $hookUrl = $this->getRequest()->getParam('submiturl');
                if (!$hookUrl) {
                    $this->logger->error('ERROR: Invalid PunchOut request');
                    $result->setContents('Proceedo cXML require a submiturl parameter');
                    $result->setStatusHeader(500);
                    return $result;
                } else {
                    $this->logger->info('Proceedo cXML login request for hook : ' . $hookUrl);

                    if ($this->getRequest()->isPost()) {
                        $body = $this->getRequest()->getContent();
                        $this->logger->info($body);
                    }
                }
                $page = $this->resultPageFactory->create();
                return $page;
            }
        } catch (\Exception $e) {
            $this->logger->error($e->getMessage());
            $result->setContents('Internal error, see log for more information');
            $result->setStatusHeader(400);
        } catch (\Throwable $t) {
            $this->logger->error($t->getMessage());
            $result->setContents('Internal error, see log for more information');
            $result->setStatusHeader(500);
        }

        return $result;
    }

    private function getRequest() : \Magento\Framework\App\Request\Http
    {
        return $this->request;
    }
}