<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Model;

use Ecomero\PunchOut\Helper\Data;

abstract class MessageBase
{
    public const XML_VALUE_MISSING = 'ej angivet';

    public function __construct(
        protected Data $data
    ) {
    }

    protected function isAuthorized(\SimpleXMLElement $xml) : bool
    {
        $validIdentity = $this->data->getSenderIdentity(Data::SCOPE_TYPE_STORE);
        $validSecret = $this->data->getSharedSecret(Data::SCOPE_TYPE_STORE);

        $senderIdentity = strtolower((string)$xml->Header->Sender->Credential->Identity);
        $fromIdentity = strtolower((string)$xml->Header->From->Credential->Identity);
        $sharedSecret = (string)$xml->Header->Sender->Credential->SharedSecret;

        return ($senderIdentity === $validIdentity ||
                $fromIdentity === $validIdentity) &&
                $sharedSecret === $validSecret;
    }

    protected function createPayloadId() : string
    {
        return (new \DateTime())->getTimestamp() . '.' . getmypid() . '.' . rand() . '@' . gethostname();
    }

    protected function getXMLValue(\SimpleXMLElement $xml, string $path) : string
    {
        $node = $xml->xpath($path);

        if (!$node) {
            return self::XML_VALUE_MISSING;
        }

        if (!is_array($node)) {
            return self::XML_VALUE_MISSING;
        }

        if (count($node) === 0) {
            return self::XML_VALUE_MISSING;
        }

        $rc = (string)reset($node);
        if ($rc === "") {
            return self::XML_VALUE_MISSING;
        }
        return $rc;
    }

    protected function createXmlResponse(
        String $payloadId,
        int $statusCode,
        string $statusText
    ) : \SimpleXMLElement {
        $xml_header =   '<?xml version="1.0" encoding="UTF-8"?>' .
                        '<!DOCTYPE cXML SYSTEM "http://xml.cXML.org/schemas/cXML/1.2.040/cXML.dtd"><cXML></cXML>';
        $xml = new \SimpleXMLElement($xml_header);
        $xml->addAttribute('payloadID', $payloadId);
        $now = new \DateTime();
        $xml->addAttribute('timestamp', $now->format('Y-m-d\TH:i:sP'));
        $responseNode = $xml->addChild('Response');

        $statusNode = $responseNode->addChild('Status');
        $statusNode->addAttribute('code', strval($statusCode));
        $statusNode->addAttribute('text', $statusText);

        return $xml;
    }
}
