<?php

declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */

namespace Ecomero\PunchOut\Model\Proceedo;

use Ecomero\PunchOut\Helper\Data;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Store\Model\Information;
use Magento\Store\Model\StoreManagerInterface;

class OrderResponse extends \Ecomero\PunchOut\Model\MessageBase
{
    public function __construct(
        protected ArrayManager $arrayManager,
        protected Data $data,
        protected Information $storeInformation,
        protected StoreManagerInterface $storeManager,
        protected CustomerSession $customerSession
    ) {
        parent::__construct($data);
    }

    public function createCXMLResponse(
        \SimpleXMLElement $xml,
        int $statusCode,
        String $statusText = null
    ): \SimpleXMLElement {
        $xmlResponse = $this->createXmlResponse((string)$xml['payloadID'], $statusCode, $statusText);
        return $xmlResponse;
    }

    public function createXCBLResponse(
        \SimpleXMLElement $xml,
        String $responseType,
        String $headerNote = null
    ): \SimpleXMLElement {
        $xml_header =   '<?xml version="1.0" encoding="UTF-8"?>' .
            '<OrderResponse xmlns="rrn:org.xcbl:schemas/xcbl/v3_5/xcbl35.xsd"></OrderResponse>';
        $responseXml = new \SimpleXMLElement($xml_header);
        $nodeHeader = $responseXml->addChild('OrderResponseHeader');
        $nodeNumber = $nodeHeader->addChild('OrderResponseNumber');

        $orderId = (string)$this->getXMLValue($xml, "Request/OrderRequest/OrderRequestHeader/@orderID");
        $nodeNumber->addChild('BuyerOrderResponseNumber', $orderId);
        $nodeNumber->addChild('SellerOrderResponseNumber', $orderId);

        $now = new \DateTime();
        $nodeHeader->addChild('OrderResponseIssueDate', $now->format('Ymd\TH:i:sP'));
        $nodeHeader->addChild('OrderResponseDocTypeCoded', 'OrderResponse');
        $nodeHeader->addChild('OrderReference')
            ->addChild('Reference')
            ->addChild('RefNum', $orderId);

        $vatNumber = $this->data->getStoreVatNumber();
        $name = $this->data->getStoreName();
        $this->addParty(
            $nodeHeader->addChild('SellerParty'),
            $vatNumber,
            $name
        );

        $buyerVATNumber = (string)$this->getXMLValue($xml, "Header/From/Credential[@domain='VATNO']/Identity");
        $buyerName = (string)$this->getXMLValue($xml, "Request/OrderRequest/OrderRequestHeader/ShipTo/Address/Name");
        $this->addParty(
            $nodeHeader->addChild('BuyerParty'),
            $buyerVATNumber,
            $buyerName
        );

        $nodeHeader->addChild('Purpose')->addChild('PurposeCoded', 'Original');
        $nodeHeader->addChild('ResponseType')->addChild('ResponseTypeCoded', $responseType);

        if ($headerNote) {
            $nodeHeader->addChild('OrderResponseHeaderNote', $headerNote);
        }

        return $responseXml;
    }

    private function addParty(
        \SimpleXMLElement $node,
        String $vatNumber,
        String $name
    ): \SimpleXMLElement {
        $nodeParty = $node->addChild('Party');
        $nodeIdentifier = $nodeParty->addChild('PartyID')->addChild('Identifier');
        $nodeIdentifier->addChild('Agency')->addChild('AgencyCoded', '');
        $nodeIdentifier->addChild('Ident', $vatNumber);
        $nodeParty->addChild('NameAddress')
            ->addChild('Name1', $name);
        return $node;
    }
}
