<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Model;

use Ecomero\PunchOut\Api\Data\SetupInterface;
use Magento\Framework\Model\AbstractModel;

class Setup extends AbstractModel implements SetupInterface
{
    protected array $setupItems = [];

    protected function _construct(): void
    {
        $this->_init(\Ecomero\PunchOut\Model\ResourceModel\Setup::class);
    }

    public function getItems() : array
    {
        return $this->setupItems;
    }

    public function setItems(array $items)
    {
        $this->setupItems = $items;
    }

    public function getId() : ?string
    {
        return $this->_getData(self::SETUP_ID);
    }

    public function setId($id)
    {
        $this->setData(self::SETUP_ID, $id);
    }

    public function getToken() : string
    {
        return $this->_getData(self::TOKEN);
    }

    public function setToken(string $token) : void
    {
        $this->setData(self::TOKEN, $token);
    }

    public function getSessionId() : ?string
    {
        return $this->_getData(self::SESSION_ID);
    }

    public function setSessionId(string $sessionId) : void
    {
        $this->setData(self::SESSION_ID, $sessionId);
    }

    public function getCreated() : ?\DateTime
    {
        return $this->_getData(self::CREATED);
    }

    public function setCreated(\DateTime $date) : void
    {
        $this->setData(self::CREATED, $date);
    }

    public function getPayloadId() : string
    {
        return $this->_getData(self::PAYLOAD_ID);
    }

    public function setPayloadId(string $payloadId) : void
    {
        $this->setData(self::PAYLOAD_ID, $payloadId);
    }

    public function getTimeStamp() : ?\DateTime
    {
        return $this->_getData(self::TIMESTAMP);
    }

    public function setTimeStamp(\DateTime $date) : void
    {
        $this->setData(self::TIMESTAMP, $date);
    }

    public function getHeaderFromDomain() : ?string
    {
        return $this->_getData(self::HEADER_FROM_DOMAIN);
    }

    public function setHeaderFromDomain(string $domain) : void
    {
        $this->setData(self::HEADER_FROM_DOMAIN, $domain);
    }

    public function getHeaderFromIdentity() : ?string
    {
        return $this->_getData(self::HEADER_FROM_IDENTITY);
    }

    public function setHeaderFromIdentity(string $identity) : void
    {
        $this->setData(self::HEADER_FROM_IDENTITY, $identity);
    }

    public function getHeaderToDomain() : ?string
    {
        return $this->_getData(self::HEADER_TO_DOMAIN);
    }

    public function setHeaderToDomain(string $domain) : void
    {
        $this->setData(self::HEADER_TO_DOMAIN, $domain);
    }

    public function getHeaderToIdentity() : ?string
    {
        return $this->_getData(self::HEADER_TO_IDENTITY);
    }

    public function setHeaderToIdentity(string $identity) : void
    {
        $this->setData(self::HEADER_TO_IDENTITY, $identity);
    }

    public function getHeaderSenderDomain() : ?string
    {
        return $this->_getData(self::HEADER_SENDER_DOMAIN);
    }

    public function setHeaderSenderDomain(string $domain) : void
    {
        $this->setData(self::HEADER_SENDER_DOMAIN, $domain);
    }

    public function getHeaderSenderIdentity() : string
    {
        return $this->_getData(self::HEADER_SENDER_IDENTITY);
    }

    public function setHeaderSenderIdentity(string $identity) : void
    {
        $this->setData(self::HEADER_SENDER_IDENTITY, $identity);
    }

    public function getHeaderSenderUserAgent() : ?string
    {
        return $this->_getData(self::HEADER_SENDER_USER_AGENT);
    }

    public function setHeaderSenderUserAgent(string $userAgent) : void
    {
        $this->setData(self::HEADER_SENDER_USER_AGENT, $userAgent);
    }

    public function getRequestDeploymentMode() : ?string
    {
        return $this->_getData(self::REQUEST_DEPLOYMENT_MODE);
    }

    public function setRequestDeploymentMode(string $mode) : void
    {
        $this->setData(self::REQUEST_DEPLOYMENT_MODE, $mode);
    }

    public function getRequestOperation() : string
    {
        return $this->_getData(self::REQUEST_OPERATION);
    }

    public function setRequestOperation(string $operation) : void
    {
        $this->setData(self::REQUEST_OPERATION, $operation);
    }

    public function getRequestBuyerCookie() : ?string
    {
        return $this->_getData(self::REQUEST_BUYER_COOKIE);
    }

    public function setRequestBuyerCookie(string $cookie) : void
    {
        $this->setData(self::REQUEST_BUYER_COOKIE, $cookie);
    }

    public function getRequestBrowserFormPostUrl() : string
    {
        return $this->_getData(self::REQUEST_BROWSER_FORM_POST_URL);
    }

    public function setRequestBrowserFormPostUrl(string $url) : void
    {
        $this->setData(self::REQUEST_BROWSER_FORM_POST_URL, $url);
    }

    public function getRequestSupplierSetupUrl() : string
    {
        return $this->_getData(self::REQUEST_SUPPLIER_SETUP_URL);
    }

    public function setRequestSupplierSetupUrl(string $url) : void
    {
        $this->setData(self::REQUEST_SUPPLIER_SETUP_URL, $url);
    }

    public function getRequestExtrinsic() : ?string
    {
        return $this->_getData(self::REQUEST_EXTRINSIC);
    }

    public function setRequestExtrinsic(string $extrinsic) : void
    {
        $this->setData(self::REQUEST_EXTRINSIC, $extrinsic);
    }

    public function getRequestContactName() : ?string
    {
        return $this->_getData(self::REQUEST_CONTACT_NAME);
    }

    public function setRequestContactName(string $extrinsic) : void
    {
        $this->setData(self::REQUEST_CONTACT_NAME, $extrinsic);
    }

    public function getRequestContactEmail() : ?string
    {
        return $this->_getData(self::REQUEST_CONTACT_EMAIL);
    }

    public function setRequestContactEmail(string $extrinsic) : void
    {
        $this->setData(self::REQUEST_CONTACT_EMAIL, $extrinsic);
    }

    public function getRequestShipToId() : ?string
    {
        return $this->_getData(self::REQUEST_SHIP_TO_ID);
    }

    public function setRequestShipToId(string $id) : void
    {
        $this->setData(self::REQUEST_SHIP_TO_ID, $id);
    }

    public function getRequestShipToName() : ?string
    {
        return $this->_getData(self::REQUEST_SHIP_TO_NAME);
    }

    public function setRequestShipToName(string $name) : void
    {
        $this->setData(self::REQUEST_SHIP_TO_NAME, $name);
    }

    public function getRequestShipToStreet() : ?string
    {
        return $this->_getData(self::REQUEST_SHIP_TO_STREET);
    }

    public function setRequestShipToStreet(string $street) : void
    {
        $this->setData(self::REQUEST_SHIP_TO_STREET, $street);
    }

    public function getRequestShipToCity() : ?string
    {
        return $this->_getData(self::REQUEST_SHIP_TO_CITY);
    }

    public function setRequestShipToCity(string $city) : void
    {
        $this->setData(self::REQUEST_SHIP_TO_CITY, $city);
    }

    public function getRequestShipToState() : ?string
    {
        return $this->_getData(self::REQUEST_SHIP_TO_STATE);
    }

    public function setRequestShipToState(string $state) : void
    {
        $this->setData(self::REQUEST_SHIP_TO_STATE, $state);
    }

    public function getRequestShipToPostalCode() : ?string
    {
        return $this->_getData(self::REQUEST_SHIP_TO_POSTAL_CODE);
    }

    public function setRequestShipToPostalCode(string $postalCode) : void
    {
        $this->setData(self::REQUEST_SHIP_TO_POSTAL_CODE, $postalCode);
    }

    public function getRequestShipToCountry() : ?string
    {
        return $this->_getData(self::REQUEST_SHIP_TO_COUNTRY);
    }

    public function setRequestShipToCountry(string $country) : void
    {
        $this->setData(self::REQUEST_SHIP_TO_COUNTRY, $country);
    }
}
