<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Model;

use Ecomero\PunchOut\Api\Data\SetupItemInterface;
use Magento\Framework\Model\AbstractModel;

class SetupItem extends AbstractModel implements SetupItemInterface
{
    protected function _construct()
    {
        $this->_init(\Ecomero\PunchOut\Model\ResourceModel\SetupItem::class);
    }

    public function getId() : ?string
    {
        return $this->_getData(self::ITEM_ID);
    }

    public function setId($id)
    {
        $this->setData(self::ITEM_ID, $id);
    }

    public function getSetupId() : int
    {
        return $this->_getData(self::SETUP_ID);
    }

    public function setSetupId(int $id) : void
    {
        $this->setData(self::SETUP_ID, $id);
    }

    public function getQuantity() : float
    {
        return (float)$this->_getData(self::QUANTITY);
    }
    public function setQuantity(float $qty) : void
    {
        $this->setData(self::QUANTITY, $qty);
    }

    public function getSupplierPartId() : string
    {
        return $this->_getData(self::SUPPLIER_PART_ID);
    }
    public function setSupplierPartId(string $partId) : void
    {
        $this->setData(self::SUPPLIER_PART_ID, $partId);
    }

    public function getSupplierPartAuxiliaryId() : string
    {
        return $this->_getData(self::SUPPLIER_PART_AUXILIARY_ID);
    }

    public function setSupplierPartAuxiliaryId(string $partId) : void
    {
        $this->setData(self::SUPPLIER_PART_AUXILIARY_ID, $partId);
    }
}
