<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Api;

use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;

/**
 * Setup Item Repository Interface
 *
 * Service contract for managing PunchOut setup items
 * @api
 * @since 2.0.0
 */
interface SetupItemRepositoryInterface
{
    /**
     * Load setup item from XML element
     *
     * Parses cXML item data and creates a SetupItem entity
     *
     * @param \SimpleXMLElement $xml The XML element containing item data
     * @return \Ecomero\PunchOut\Api\Data\SetupItemInterface
     * @throws \InvalidArgumentException If XML structure is invalid
     * @since 2.0.0
     */
    public function loadFromXml(\SimpleXMLElement $xml): Data\SetupItemInterface;

    /**
     * Retrieve setup items matching search criteria
     *
     * Returns a collection of setup items based on provided search criteria.
     * Useful for filtering, sorting, and pagination of setup items.
     *
     * @param SearchCriteriaInterface $criteria Search criteria for filtering items
     * @return SearchResultsInterface Search results containing matching items
     * @throws \Magento\Framework\Exception\LocalizedException
     * @since 2.0.0
     */
    public function getList(SearchCriteriaInterface $criteria): SearchResultsInterface;
}
