<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\PunchOut\Block;

use Ecomero\PunchOut\Api\SetupRepositoryInterface;
use Ecomero\PunchOut\Helper\Data;
use Ecomero\PunchOut\Helper\QuoteHelper;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Customer\Api\AccountManagementInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Model\CustomerFactory;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Framework\View\Element\Template\Context;
use Magento\Store\Model\StoreManagerInterface;

class Index extends \Magento\Framework\View\Element\Template
{
    public function __construct(
        Context $context,
        protected SetupRepositoryInterface $repository,
        protected CustomerSession $customerSession,
        protected CheckoutSession $checkoutSession,
        protected CustomerRepositoryInterface $customerRepo,
        protected CustomerFactory $customerFactory,
        protected QuoteHelper $quoteHelper,
        protected AccountManagementInterface $customerAccountManagement,
        protected Data $settings,
        protected StoreManagerInterface $storeManager,
        array $data = []
    ) {
        parent::__construct($context, $data);
    }

    public function loginUser(): string
    {
        $rc = 'Login message not recognized';
        $this->customerSession->logout();

        $hookUrl = $this->getRequest()->getParam('HOOK_URL');
        $token = $this->getRequest()->getParam('token');
        if (null !== $hookUrl) {
            $rc = $this->loginUserOciRoundTrip();
        } elseif (null !== $token) {
            $rc = $this->loginUserCXML($token);
        }

        return $rc;
    }

    public function loginUserOciRoundTrip(): string
    {
        $rc = 'Username, Password or Hook is missing from URL';
        $username = $this->getRequest()->getParam('USERNAME');
        $password = $this->getRequest()->getParam('PASSWORD');
        $hookUrl = $this->getRequest()->getParam('HOOK_URL');
        $target = $this->getRequest()->getParam('~TARGET');

        if (!empty($username) && !empty($password) && !empty($hookUrl)) {
            try {
                if ($this->settings->isLoginUser()) {
                    // Authenticate will throw exception on error
                    $this->customerAccountManagement->authenticate($username, $password);

                    try {
                        $customer = $this->customerRepo->get($username);
                        $customer = $this->customerFactory->create()->load($customer->getId());
                    } catch (\Exception $exception) {
                        return 'No user found for ' . $username;
                    }
                    $this->customerSession->setCustomerAsLoggedIn($customer);
                    $cartId = (int) $this->checkoutSession->getQuote()->getId();
                    $this->quoteHelper->clearCart($cartId);
                }

                $this->customerSession->setData(
                    'punchout',
                    (object) ['type' => 'oci',
                        'store' => $this->storeManager->getStore()->getCode(),
                        'baseUrl' => $this->getBaseUrl(),
                        'hookUrl' => $hookUrl,
                        'target' => $target,
                    ]
                );
                $rc = 'OK';
            } catch (\Magento\Framework\Exception\EmailNotConfirmedException $e) {
                $rc = 'EmailNotConfirmedException';
            } catch (\Magento\Framework\Exception\State\UserLockedException $e) {
                $rc = 'UserLockedException';
            } catch (\Magento\Framework\Exception\AuthenticationException $e) {
                $rc = 'AuthenticationException';
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $rc = 'LocalizedException';
            } catch (\Exception $e) {
                $rc = 'Login failed';
            }
        }

        return $rc;
    }

    public function loginUserCXML(string $token): string
    {
        $setup = $this->repository->getByToken($token);

        if (null === $setup) {
            return 'Invalid token';
        }

        $email = $setup->getRequestContactEmail();
        if (null === $email) {
            $extrinsic = unserialize($setup->getRequestExtrinsic());
            if (array_key_exists('UserEmail', $extrinsic)) {
                $email = $extrinsic['UserEmail'];
            }
        }
        if (null === $email) {
            return 'Invalid email';
        }

        try {
            $customer = $this->customerRepo->get($email);
            $customer = $this->customerFactory->create()->load($customer->getId());
        } catch (\Exception $exception) {
            return 'No user found for ' . $email;
        }

        $this->customerSession->setCustomerAsLoggedIn($customer);
        $this->customerSession->setData(
            'punchout',
            (object) ['type' => 'cxml',
                'store' => $this->storeManager->getStore()->getCode(),
                'baseUrl' => $this->getBaseUrl(),
                'hookUrl' => $setup->getRequestBrowserFormPostUrl(),
                'data' => $setup, ]
        );

        $cartId = (int) $this->checkoutSession->getQuote()->getId();
        $this->quoteHelper->clearCart($cartId);

        if ('edit' === $setup->getRequestOperation()) {
            foreach ($setup->getItems() as $item) {
                $this->quoteHelper->addCartProduct(
                    $cartId,
                    (int) $item->getSupplierPartAuxiliaryId(),
                    $item->getSupplierPartId(),
                    $item->getQuantity()
                );
            }
        }

        return 'OK';
    }
}
