<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Helper;

use Magento\Catalog\Model\Product\Attribute\Repository;
use Magento\Catalog\Model\ProductRepository;
use Magento\Quote\Model\Quote\Item;
use Magento\Quote\Model\QuoteRepository;

class QuoteHelper
{
    public function __construct(
        protected QuoteRepository $quoteRepository,
        protected ProductRepository $productRepository,
        protected Repository $attributeRepository,
        protected Item $quoteItem
    ) {
    }

    public function clearCart(int $cartId)
    {
        $quote = $this->quoteRepository->get($cartId);
        foreach ($quote->getItems() as $item) {
            $item->getItemId();

            $cartItemId = $item->getItemId();
            $itemObj = $this->quoteItem->load($cartItemId);
            $itemObj->delete();
        }
        $this->quoteRepository->save($quote);
    }

    public function addCartProduct(int $cartId, int $productId, string $sku, float $qty)
    {
        /** @var \Magento\Quote\Model\Quote $quote */
        $quote = $this->quoteRepository->get($cartId);
        /** @var \Magento\Catalog\Model\Product $product */
        $product = $this->productRepository->getById($productId);

        if ($quote && $product) {
            if ($product->getTypeId() == \Magento\GroupedProduct\Model\Product\Type\Grouped::TYPE_CODE) {
                /** @var \Magento\GroupedProduct\Model\Product\Type\Grouped $typedProduct */
                $typedProduct = $product->getTypeInstance();
                foreach ($typedProduct->getChildrenIds($productId, false) as $children) {
                    foreach ($children as $id) {
                        $_product = $this->productRepository->getById($id);
                        $quote->addProduct($_product, $this->makeAddRequest($_product, $sku, $qty));
                    }
                }
            } else {
                $quote->addProduct($product, $this->makeAddRequest($product, $sku, $qty));
            }
            $this->quoteRepository->save($quote);
        }
    }

    public function addOrderProduct(\Magento\Quote\Model\Quote $quote, string $sku, float $qty)
    {
        /** @var \Magento\Catalog\Model\Product $product */
        $product = $this->productRepository->get($sku, false, $quote->getStoreId());

        if ($quote && $product) {
            if ($product->getTypeId() == \Magento\GroupedProduct\Model\Product\Type\Grouped::TYPE_CODE) {
                /** @var \Magento\GroupedProduct\Model\Product\Type\Grouped $typedProduct */
                $typedProduct = $product->getTypeInstance();
                foreach ($typedProduct->getChildrenIds($product->getId(), false) as $children) {
                    foreach ($children as $id) {
                        $_product = $this->productRepository->getById($id);
                        $quote->addProduct($_product, $this->makeAddRequest($_product, $sku, $qty));
                    }
                }
            } else {
                $quote->addProduct($product, $this->makeAddRequest($product, $sku, $qty));
            }
        }
    }

    private function makeAddRequest(\Magento\Catalog\Model\Product $product, $sku = null, $qty = 1)
    {
        $data = [
            'product' => $product->getEntityId(),
            'qty' => $qty
        ];
        switch ($product->getTypeId()) {
            case \Magento\ConfigurableProduct\Model\Product\Type\Configurable::TYPE_CODE:
                $data = $this->setConfigurableRequestOptions($product, $sku, $data);
                break;
            case \Magento\Bundle\Model\Product\Type::TYPE_CODE:
                $data = $this->setBundleRequestOptions($product, $data);
                break;
        }
        $request = new \Magento\Framework\DataObject();
        $request->setData($data);
        return $request;
    }

    private function setConfigurableRequestOptions(\Magento\Catalog\Model\Product $product, $sku, array $data)
    {
        /** @var \Magento\ConfigurableProduct\Model\Product\Type\Configurable $typedProduct */
        $typedProduct = $product->getTypeInstance();
        /** @var \Magento\Catalog\Model\Product $childProduct */
        $childProduct = $this->productRepository->get($sku);
        $productAttributeOptions = $typedProduct->getConfigurableAttributesAsArray($product);
        $superAttributes = [];
        foreach ($productAttributeOptions as $option) {
            $superAttributes[$option['attribute_id']] = $childProduct->getData($option['attribute_code']);
        }
        $data['super_attribute'] = $superAttributes;
        return $data;
    }

    private function setBundleRequestOptions(\Magento\Catalog\Model\Product $product, array $data)
    {
        /** @var \Magento\Bundle\Model\Product\Type $typedProduct */
        $typedProduct = $product->getTypeInstance();
        $selectionCollection = $typedProduct->getSelectionsCollection($typedProduct->getOptionsIds($product), $product);
        $options = [];
        foreach ($selectionCollection as $proselection) {
            $options[$proselection->getOptionId()] = $proselection->getSelectionId();
        }
        $data['bundle_option'] = $options;
        return $data;
    }
}
