<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\PunchOut\Model;

use Ecomero\PunchOut\Api\Data\SetupItemInterface;
use Ecomero\PunchOut\Api\Data\SetupItemInterfaceFactory;
use Ecomero\PunchOut\Api\SetupItemRepositoryInterface;
use Ecomero\PunchOut\Model\ResourceModel\SetupItem\CollectionFactory;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Api\SearchResultsInterfaceFactory;

/**
 * Setup Item Repository
 *
 * Repository implementation for managing PunchOut setup items
 * @since 2.0.0
 */
class SetupItemRepository implements SetupItemRepositoryInterface
{
    public function __construct(
        private SetupItemInterfaceFactory $setupItemFactory,
        private CollectionFactory $collectionFactory,
        private SearchResultsInterfaceFactory $searchResultsFactory,
        private CollectionProcessorInterface $collectionProcessor
    ) {
    }

    /**
     * @inheritDoc
     */
    public function loadFromXml(\SimpleXMLElement $xml): SetupItemInterface
    {
        $setupItem = $this->setupItemFactory->create();
        $setupItem->setQuantity((float)$xml['quantity']);
        $setupItem->setSupplierPartId((string)$xml->ItemID->SupplierPartID);
        $setupItem->setSupplierPartAuxiliaryId((string)$xml->ItemID->SupplierPartAuxiliaryID);
        return $setupItem;
    }

    /**
     * @inheritDoc
     */
    public function getList(SearchCriteriaInterface $criteria): SearchResultsInterface
    {
        $searchResult = $this->searchResultsFactory->create();
        $collection = $this->collectionFactory->create();
        $this->collectionProcessor->process($criteria, $collection);
        $searchResult->setItems($collection->getItems());
        $searchResult->setTotalCount($collection->getSize());

        return $searchResult;
    }
}
