<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\Pyramid\Model\Erp;

use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpInvoiceInterface;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Ecomero\Pyramid\Model\PyramidAdapter;
use Ecomero\Pyramid\Model\PyramidAPI;
use Magento\Framework\Stdlib\ArrayManager;

class PyramidInvoice extends PyramidAdapter implements ErpInvoiceInterface
{
    public function __construct(
        PyramidAPI $api,
        Settings $settings,
        Capability $capability,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory,
        ArrayManager $arrayManager
    ) {
        parent::__construct(
            $api,
            $settings,
            $capability,
            $arrayManager,
            $storeManager,
            $orderResponseFactory
        );
    }

    public function getInvoiceFromOrder(string $orderNo): array
    {
        return $this->pyramidAPI->get("command=invoice&externalDocumentNumber={$orderNo}");
    }
}
