<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\Pyramid\Model;

use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Store\Model\StoreManagerInterface;

class PyramidAdapter extends \Ecomero\ErpCore\Model\Erp\ErpAdapter
{
    public const ERP_NAME = 'Pyramid';
    public const MAX_COMMENT_LEN = 60;
    protected $pyramidAPI;
    protected $itemListCache;
    protected $settings;
    protected $currentOrder;
    protected $arrayManager;
    protected $orderResponseFactory;

    public function __construct(
        PyramidAPI $pyramidAPI,
        Settings $settings,
        Capability $capability,
        ArrayManager $arrayManager,
        StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory
    ) {
        parent::__construct($storeManager);

        $this->pyramidAPI = $pyramidAPI;
        $this->settings = $settings;
        $this->capability = $capability;
        $this->arrayManager = $arrayManager;
        $this->orderResponseFactory = $orderResponseFactory;

        $this->capability->setName(self::ERP_NAME);
        $this->capability->setCapability(Capability::PRODUCT_IMPORT, true);
        $this->capability->setCapability(Capability::ORDER_EXPORT, true);
        $this->capability->setCapability(Capability::ORDER_IMPORT, true);
        $this->capability->setCapability(Capability::COMPANY_IMPORT, true);
        $this->capability->setCapability(Capability::PRICE_IMPORT, true);
        $this->capability->setCapability(Capability::SHIPMENT_IMPORT, true);
        $this->capability->setCapability(Capability::INVOICE_IMPORT, true);
    }

    public function isErpEnabled(): string
    {
        if ($this->settings->isEnabled($this->getWebsite())) {
            return self::ERP_NAME;
        }

        return '';
    }

    public function getCapabilities(): array
    {
        $result[] = $this->capability;

        return $result;
    }
}
