<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\Pyramid\Model\Erp;

use Ecomero\ErpCore\Helper\Settings;
use Ecomero\ErpCore\Model\Capability;
use Ecomero\ErpCore\Model\Erp\ErpCustomerInterface;
use Ecomero\ErpCore\Model\Order\ResponseFactory as OrderResponseFactory;
use Ecomero\Pyramid\Model\PyramidAdapter;
use Ecomero\Pyramid\Model\PyramidAPI;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Store\Model\StoreManagerInterface;

class PyramidCustomer extends PyramidAdapter implements ErpCustomerInterface
{
    public function __construct(
        PyramidAPI $pyramidAPI,
        Settings $settings,
        Capability $capability,
        ArrayManager $arrayManager,
        StoreManagerInterface $storeManager,
        OrderResponseFactory $orderResponseFactory
    ) {
        parent::__construct(
            $pyramidAPI,
            $settings,
            $capability,
            $arrayManager,
            $storeManager,
            $orderResponseFactory
        );
    }

    public function getCompanyList(): array
    {
        return $this->pyramidAPI->get('command=company');
    }

    public function getCustomerCategories(): array
    {
        return [];
    }

    public function getCustomerDistricts(): array
    {
        return [];
    }

    public function getCustomerFromEmail(
        string $email
    ): array {
        return $this->pyramidAPI->get("command=customer&email={$email}");
    }

    public function createCustomer(
        ?string $company,
        ?string $firstName,
        ?string $lastName,
        ?string $street,
        ?string $city,
        ?string $postCode,
        ?string $email,
        ?string $phone,
        ?string $country,
        ?string $region,
        ?string $vatNumber
    ): array {
        throw new \Exception('Not implemented');
    }
}
