<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\Pyramid\Model;

use Ecomero\ErpCore\Helper\WebSocket;
use Ecomero\Pyramid\Helper\Data;
use Magento\Framework\Stdlib\ArrayManager;

class PyramidAPI
{
    protected $webSocket;
    protected $data;
    protected $arrayManager;

    public function __construct(
        WebSocket $webSocket,
        Data $data,
        ArrayManager $arrayManager
    ) {
        $this->webSocket = $webSocket;
        $this->data = $data;
        $this->arrayManager = $arrayManager;
    }

    public function post(string $command, array $payload): array
    {
        $mode = $this->data->getMode();

        $payload['mode'] = $mode;
        $encodedPayload = base64_encode(json_encode($payload));

        return $this->webSocket->get($command."&payload={$encodedPayload}");
    }

    public function get(string $command): array
    {
        $mode = $this->data->getMode();

        return $this->webSocket->get("{$command}&mode={$mode}");
    }
}
