<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\Pyramid\Helper;

use Magento\Company\Api\CompanyRepositoryInterface;
use Magento\Framework\Locale\Resolver as LocaleResolver;

class TermsHelper
{
    public const TERM_TYPE_PAYMENT = 150;
    public const TERM_TYPE_DELIVERY = 151;
    public const TERM_TYPE_DELIVERY_METHOD = 152;

    protected $companyRepository;
    protected $localeResolver;

    public function __construct(
        CompanyRepositoryInterface $companyRepository,
        LocaleResolver $localeResolver
    ) {
        $this->companyRepository = $companyRepository;
        $this->localeResolver = $localeResolver;
    }

    public function getTerms(int $entityId, int $type): string
    {
        try {
            /** @var \Ecomero\ErpB2b\Api\Data\CompanyErpInterface $company */
            $company = $this->companyRepository->get($entityId);

            if ($company) {
                $language = $this->getCurrentLanguage();
                $terms = json_decode($company->getErpTerms() ?? '', true) ?? [];
                foreach ($terms as $term) {
                    if ($term['language'] === $language && $term['type'] === $type) {
                        return $term['description'];
                    }
                }
            }
        } catch (\Magento\Framework\Exception\NoSuchEntityException $e) {
        }

        return '';
    }

    private function getCurrentLanguage(): string
    {
        $language = 'SE';
        $locale = $this->localeResolver->getLocale();
        if ('en_US' === $locale) {
            $language = 'EN';
        } elseif ('sv_SE' === $locale) {
            $language = 'SE';
        }

        return $language;
    }
}
