<?php

declare(strict_types=1);
/**
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'.
 *
 *           Copyright © eComero Management AB, All rights reserved.
 */

namespace Ecomero\Pyramid\Setup\Patch\Data;

use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

/**
 * Patch is mechanism, that allows to do atomic upgrade data changes.
 */
class ProductAttributes3 implements DataPatchInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @var EavSetupFactory
     */
    private $eavSetupFactory;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    /**
     * Do Upgrade.
     */
    public function apply()
    {
        $this->moduleDataSetup->startSetup();
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);

        $eavSetup->removeAttribute(\Magento\Catalog\Model\Product::ENTITY, 'qty_producible');
        $eavSetup->addAttribute(
            \Magento\Catalog\Model\Product::ENTITY,
            'qty_producible',
            [
                'type' => 'varchar',
                'input' => 'text',
                'label' => 'Producible Qty',
                'used_in_product_listing' => false,
                'visible' => true,
                'user_defined' => true,
                'visible_on_front' => true,
                'filterable' => false,
                'searchable' => false,
                'required' => false,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
            ]
        );
        $this->assignAttributeToAllSets($eavSetup, 'qty_producible');

        $eavSetup->removeAttribute(\Magento\Catalog\Model\Product::ENTITY, 'qty_producible_updated');
        $eavSetup->addAttribute(
            \Magento\Catalog\Model\Product::ENTITY,
            'qty_producible_updated',
            [
                'type' => 'varchar',
                'input' => 'text',
                'label' => 'Producible Qty Last Updated',
                'used_in_product_listing' => false,
                'visible' => true,
                'user_defined' => true,
                'visible_on_front' => true,
                'filterable' => false,
                'searchable' => false,
                'required' => false,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
            ]
        );
        $this->assignAttributeToAllSets($eavSetup, 'qty_producible_updated');
        $this->moduleDataSetup->endSetup();
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [];
    }

    private function assignAttributeToAllSets(\Magento\Eav\Setup\EavSetup $eavSetup, string $attributeCode)
    {
        $ATTRIBUTE_GROUP = 'General'; // Attribute Group Name
        $entityTypeId = $eavSetup->getEntityTypeId(\Magento\Catalog\Model\Product::ENTITY);
        $allAttributeSetIds = $eavSetup->getAllAttributeSetIds($entityTypeId);
        foreach ($allAttributeSetIds as $attributeSetId) {
            $groupId = $eavSetup->getAttributeGroupId($entityTypeId, $attributeSetId, $ATTRIBUTE_GROUP);
            $eavSetup->addAttributeToGroup(
                $entityTypeId,
                $attributeSetId,
                $groupId,
                $attributeCode,
                null
            );
        }
    }
}
