<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\VismaSPCS\Block\Adminhtml\Config\Form\Field;

use Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory;
use Magento\Framework\View\Element\Context;

class Attribute extends \Magento\Framework\View\Element\Html\Select
{
    protected $attributeFactory;

    public function __construct(
        Context $context,
        CollectionFactory $attributeFactory,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->attributeFactory = $attributeFactory;
    }

    public function _toHtml() : string
    {
        if (!$this->getOptions()) {
            try {
                $this->addOption('erp_common_name', '*** Common article prefix/suffix ***');
                $attributeCollection = $this->attributeFactory->create();
                $attributeCollection->setOrder('frontend_label', \Magento\Framework\Data\Collection::SORT_ORDER_ASC);
                foreach ($attributeCollection->getData() as $attrib) {
                    if ($attrib['is_visible'] === "1") {
                        $this->addOption($attrib['attribute_code'], $attrib['frontend_label']);
                    }
                }
            } catch (\Zend\Http\Exception\RuntimeException $exception) {
            } catch (\Magento\Framework\Exception\LocalizedException $exception) {
            } catch (\RuntimeException $exception) {
            }
        }
        return parent::_toHtml();
    }

    public function setInputName(string $value) : object
    {
        return $this->setName($value);
    }
}
