<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\VismaSPCS\Model\Carrier;

use Magento\Framework\Serialize\Serializer\Json;
use Magento\Quote\Model\Quote\Address\RateRequest;
use Magento\Shipping\Model\Carrier\AbstractCarrier;
use Magento\Shipping\Model\Carrier\CarrierInterface;

class VismaShipping extends AbstractCarrier implements CarrierInterface
{
    protected $_code = 'visma_shipping';
    protected $_isFixed = true;
    private $rateResultFactory;
    private $rateMethodFactory;
    private $unserializer;

    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Quote\Model\Quote\Address\RateResult\ErrorFactory $rateErrorFactory,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Shipping\Model\Rate\ResultFactory $rateResultFactory,
        \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory $rateMethodFactory,
        Json $unserializer,
        array $data = []
    ) {
        parent::__construct($scopeConfig, $rateErrorFactory, $logger, $data);

        $this->rateResultFactory = $rateResultFactory;
        $this->rateMethodFactory = $rateMethodFactory;
        $this->unserializer = $unserializer;
    }

    public function collectRates(RateRequest $request)
    {
        if (!$this->getConfigFlag('active')) {
            return false;
        }
        /** @var \Magento\Shipping\Model\Rate\Result $result */
        $result = $this->rateResultFactory->create();
        $methods = $this->getVismaShippingMethods();

        foreach ($methods as $m) {
            /** @var \Magento\Quote\Model\Quote\Address\RateResult\Method $method */
            $method = $this->rateMethodFactory->create();

            $method->setCarrier($this->_code);
            $method->setCarrierTitle(__($m['erp_visma_shipping_label']));

            $tmpArray = explode('#', $m['erp_visma_shipping_method']);
            if (count($tmpArray) === 2) {
                $shippingCode = $tmpArray[0];
                $shippingCodeName = $tmpArray[1];
                $method->setMethod($shippingCode);
                $method->setMethodTitle(__($shippingCodeName));
            }

            $shippingCost = (float)$m['erp_visma_shipping_cost'];

            $method->setPrice($shippingCost);
            $method->setCost($shippingCost);

            $result->append($method);
        }

        return $result;
    }

    private function getVismaShippingMethods() : array
    {
        $tableConfig = $this->getConfigData('available_methods');
        if ($tableConfig) {
            $tableConfigResults = $this->unserializer->unserialize($tableConfig);
            if (is_array($tableConfigResults)) {
                return $tableConfigResults;
            }
        }
        return [];
    }

    public function getAllowedMethods()
    {
        $rc = [];
        $methods = $this->getVismaShippingMethods();

        foreach ($methods as $m) {
            $tmpArray = explode('#', $m['erp_visma_shipping_method']);
            if (count($tmpArray) === 2) {
                $shippingCode = $tmpArray[0];
                $shippingCodeName = $tmpArray[1];
                $rc [$shippingCode] = $shippingCodeName;
            }
        }

        return $rc;
    }
}
