<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\VismaSPCS\Plugin;

class ConfigFormPlugin
{
    protected $configCollectionFactory;

    public function __construct(
        \Magento\Config\Model\ResourceModel\Config\Data\CollectionFactory $configCollectionFactory
    ) {
        $this->configCollectionFactory = $configCollectionFactory;
    }

    public function afterGetConfigValue(\Magento\Config\Block\System\Config\Form $type, ?string $result, string $path) : ?string
    {
        if ($path === 'erp_core/catalog/article_modified') {
            $result = '1980-01-01';
            $configCollection = $this->configCollectionFactory->create()
                                                                ->addFieldToSelect('path')
                                                                ->addFieldToSelect('scope')
                                                                ->addFieldToSelect('scope_id')
                                                                ->addFieldToSelect('value');

            foreach ($configCollection->getData() as $setting) {
                if ($setting['path'] === 'erp_core/catalog/article_modified' &&
                    $setting['scope'] === $type->getScope() &&
                    (int)$setting['scope_id'] === (int)$type->getScopeId()) {
                    $result = $setting['value'];
                    break;
                }
            }
        }

        return  $result;
    }
}
