<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\VismaSPCS\Block\System\Config\Form\Field;

class AttributeMapper extends \Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray
{
    protected $columns = [];
    protected $attributeRenderer;
    protected $addAfter = true;
    protected $addButtonLabel;

    protected function _construct()
    {
        parent::_construct();
        $this->addButtonLabel = __('Add');
    }

    protected function getAttributeRenderer() : object
    {
        if (!$this->attributeRenderer) {
            $this->attributeRenderer = $this->getLayout()->createBlock(
                \Ecomero\VismaSPCS\Block\Adminhtml\Config\Form\Field\Attribute::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }
        return $this->attributeRenderer;
    }

    protected function _prepareToRender() : void
    {
        $this->addColumn(
            'erp_sku_group',
            [
                'label' => __('Group')
            ]
        );
        $this->addColumn(
            'erp_sku_pattern',
            [
                'label' => __('Pattern')
            ]
        );
        $this->addColumn(
            'erp_sku_attribute',
            [
                'label' => __('Mapping'),
                'renderer' => $this->getAttributeRenderer()
            ]
        );
        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }

    protected function _prepareArrayRow(\Magento\Framework\DataObject $row) : void
    {
        $attribute = $row->getErpSkuAttribute();
        $options = [];
        if ($attribute) {
            $options[
                'option_' . $this->getAttributeRenderer()->calcOptionHash($attribute)
                ] = 'selected="selected"';
        }
        $row->setData('option_extra_attrs', $options);
    }

    public function renderCellTemplate($columnName)
    {
        if ($columnName == "active") {
            $this->_columns[$columnName]['class'] = 'input-text required-entry validate-number';
            $this->_columns[$columnName]['style'] = 'width:50px';
        }
        return parent::renderCellTemplate($columnName);
    }
}
