<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\VismaSPCS\Helper;

class StringUtility
{
    private static function parseGroup(string $template, int $startPos) : object
    {
        $prefix = '';
        $suffix = '';
        $group = -1;
        $nextPos = -1;
        $isPrefix = true;

        for ($pos = $startPos; $pos < strlen($template); $pos ++) {
            if ($template[$pos] === '{') {
                $isPrefix = false;

                // Beginning of group found
                if ($group !== -1) {
                    break;
                }

                $pos ++;
                $strGroup = '';
                while ($pos < strlen($template) &&
                        $template[$pos] !== '}') {
                    $strGroup = $strGroup . $template[$pos];
                    $pos ++;
                }
                $group = (int)$strGroup;
            } else {
                if ($isPrefix) {
                    $prefix = $prefix . $template[$pos];
                } else {
                    $suffix = $suffix . $template[$pos];
                }
            }
            $nextPos = $pos  + 1;
        }

        return (object)[
            'prefix' => $prefix,
            'suffix' => $suffix,
            'group' => $group,
            'nextPos' => $nextPos
        ];
    }

    private static function startsWith(string $string, int $startPos, string $pattern) : bool
    {
        if ($pattern === '') {
            return false;
        }
        $len = strlen($pattern);
        return (substr($string, $startPos, $len) === $pattern);
    }

    public static function getPartsFromString(string $template, string $stringWithParts) : array
    {
        $rc = [];
        $posS = 0;

        $groupInfo = StringUtility::parseGroup($template, 0);
        while ($groupInfo->group !== -1) {

            // Skip prefix
            for ($posP = 0;
                 $posP < strlen($groupInfo->prefix) &&
                 $posS < strlen($stringWithParts) &&
                 $stringWithParts[$posS] === $groupInfo->prefix[$posP];
                 $posP ++, $posS ++) {
            }

            // Extract part
            $part = '';
            while ($posS < strlen($stringWithParts) &&
                   !StringUtility::startsWith($stringWithParts, $posS, $groupInfo->suffix)) {
                $part = $part . $stringWithParts[$posS++];
            }

            // Check if we have no part data for the group
            if ($part === '') {
                break;
            }
            $rc[$groupInfo->group] = $part;

            // Skip suffix
            for ($posP = 0;
                 $posP < strlen($groupInfo->suffix) &&
                 $posS < strlen($stringWithParts) &&
                 $stringWithParts[$posS] === $groupInfo->suffix[$posP];
                 $posP ++, $posS ++) {
            }

            // Get next group
            $groupInfo = StringUtility::parseGroup($template, $groupInfo->nextPos);
            if ($groupInfo->group === -1) {
                break;
            }
        }
        return $rc;
    }
}
