<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\VismaSPCS\Model\Config\Source;

class SPCSFieldList extends \Magento\Framework\App\Helper\AbstractHelper implements \Magento\Framework\Data\OptionSourceInterface
{
    public function toOptionArray() : array
    {
        $arr = [];
        $arr['NOT_MAPPED'] = '--- not mapped ---';

        $arr['BILLING_NAME'] = 'Name';
        $arr['BILLING_STREET1'] = 'Street 1';
        $arr['BILLING_STREET2'] = 'Street 2';
        $arr['BILLING_GLN'] = 'GLN';
        $arr['BILLING_VISIT_ADDRESS'] = 'Visiting Address';
        $arr['BILLING_POSTAL_CODE'] = 'Postal Code';
        $arr['BILLING_CITY'] = 'City';
        $arr['BILLING_COUNTRY_CODE'] = 'Country';
        $arr['VAT'] = 'VAT';
        $arr['BILLING_PHONE'] = 'Phone';
        $arr['BILLING_PHONE2'] = 'Phone 2';
        $arr['BILLING_PHONE3'] = 'Phone 3';
        $arr['BILLING_FAX'] = 'Fax';
        $arr['BILLING_REFERENCE'] = 'Reference';
        $arr['BILLING_MOBILE'] = 'Mobile';
        $arr['EMAIL'] = 'Email';

        $arr['DELIVERY_NAME'] = 'Delivery - Name';
        $arr['DELIVERY_STREET1'] = 'Delivery - Street 1';
        $arr['DELIVERY_STREET2'] = 'Delivery - Street 2';
        $arr['DELIVERY_GLN'] = 'Delivery - GLN';
        $arr['DELIVERY_VISIT_ADDRESS'] = 'Delivery - Visiting Address';
        $arr['DELIVERY_POSTAL_CODE'] = 'Delivery - Postal Code';
        $arr['DELIVERY_CITY'] = 'Delivery - City';
        $arr['DELIVERY_COUNTRY_CODE'] = 'Delivery - Country';
        $arr['DELIVERY_PHONE'] = 'Delivery - Phone';
        $arr['DELIVERY_PHONE2'] = 'Delivery - Phone 2';
        $arr['DELIVERY_PHONE3'] = 'Delivery - Phone 3';
        $arr['DELIVERY_FAX'] = 'Delivery - Fax';

        $ret = [];

        foreach ($arr as $key => $value) {
            $ret[] = [
                'value' => $key,
                'label' => $value
            ];
        }

        return $ret;
    }
}
