<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\VismaSPCS\Test\Unit;

class StringUtilityTest extends \PHPUnit\Framework\TestCase
{
    protected $stringUtilityClass;

    public function setUp() : void
    {
        $objectManager = new \Magento\Framework\TestFramework\Unit\Helper\ObjectManager($this);
        $this->stringUtilityClass = $objectManager->getObject('Ecomero\VismaSPCS\Helper\StringUtility');
    }

    public function testPartsFromString() : void
    {
        $rc = $this->stringUtilityClass->getPartsFromString('{0}-{1}-{2}', 'HY_Pike-99-XL');
        $this->assertEquals('HY_Pike', $rc[0]);
        $this->assertEquals('99', $rc[1]);
        $this->assertEquals('XL', $rc[2]);

        $rc = $this->stringUtilityClass->getPartsFromString('{0}-{1}-{2}', 'HY_Pike-XL');
        $this->assertEquals('HY_Pike', $rc[0]);
        $this->assertEquals('XL', $rc[1]);
        $this->assertEquals(2, count($rc));

        $rc = $this->stringUtilityClass->getPartsFromString('{0}-{1}-{2}', 'HY_Pike-99-XL-38');
        $this->assertEquals('HY_Pike', $rc[0]);
        $this->assertEquals('99', $rc[1]);
        $this->assertEquals('XL-38', $rc[2]);

        $rc = $this->stringUtilityClass->getPartsFromString('{0}-{1}-{2}', 'HY_Pike');
        $this->assertEquals('HY_Pike', $rc[0]);
        $this->assertEquals(1, count($rc));

        $rc = $this->stringUtilityClass->getPartsFromString('{1}-{0}-{2}', 'HY_Pike-99-XL');
        $this->assertEquals('HY_Pike', $rc[1]);
        $this->assertEquals('99', $rc[0]);
        $this->assertEquals('XL', $rc[2]);

        $rc = $this->stringUtilityClass->getPartsFromString('{1}-{2}', 'HY_Pike-99');
        $this->assertEquals('HY_Pike', $rc[1]);
        $this->assertEquals('99', $rc[2]);
        $this->assertEquals(2, count($rc));

        $rc = $this->stringUtilityClass->getPartsFromString('{0}---{1}/{2}', 'HY_Pike---99/XL');
        $this->assertEquals('HY_Pike', $rc[0]);
        $this->assertEquals('99', $rc[1]);
        $this->assertEquals('XL', $rc[2]);

        $rc = $this->stringUtilityClass->getPartsFromString('-{0}-{1}-{2}-', '-HY_Pike-99-XL');
        $this->assertEquals('HY_Pike', $rc[0]);
        $this->assertEquals('99', $rc[1]);
        $this->assertEquals('XL', $rc[2]);
    }
}
