<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\VismaSPCS\Block\System\Config\Form\Field;

class VismaShippingMethods extends \Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray
{
    protected $columns = [];
    protected $methodRenderer;
    protected $addAfter = true;
    protected $addButtonLabel;

    protected function _construct()
    {
        parent::_construct();
        $this->addButtonLabel = __('Add');
    }

    protected function getMethodRenderer() : object
    {
        if (!$this->methodRenderer) {
            $this->methodRenderer = $this->getLayout()->createBlock(
                \Ecomero\VismaSPCS\Block\Adminhtml\Config\Form\Field\ShippingMethod::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }
        return $this->methodRenderer;
    }

    protected function _prepareToRender() : void
    {
        $this->addColumn(
            'erp_visma_shipping_method',
            [
                'label' => __('Method'),
                'renderer' => $this->getMethodRenderer()
            ]
        );
        $this->addColumn(
            'erp_visma_shipping_label',
            [
                'label' => __('Label')
            ]
        );
        $this->addColumn(
            'erp_visma_shipping_cost',
            [
                'label' => __('Cost')
            ]
        );
        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }

    protected function _prepareArrayRow(\Magento\Framework\DataObject $row) : void
    {
        $attribute = $row->getErpVismaShippingMethod();
        $options = [];
        if ($attribute) {
            $options[
                'option_' . $this->getMethodRenderer()->calcOptionHash($attribute)
                ] = 'selected="selected"';
        }
        $row->setData('option_extra_attrs', $options);
    }

    public function renderCellTemplate($columnName)
    {
        if ($columnName == "active") {
            $this->_columns[$columnName]['class'] = 'input-text required-entry validate-number';
            $this->_columns[$columnName]['style'] = 'width:50px';
        }
        return parent::renderCellTemplate($columnName);
    }
}
