<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\VismaSPCS\Helper;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;

class FieldMapper extends AbstractHelper
{
    protected $spcsFieldList;
    protected $fieldIdArray;
    protected $websiteId;

    public function __construct(
        Context $context,
        ScopeConfigInterface $scopeConfig
    ) {
        parent::__construct($context);
        $this->scopeConfig = $scopeConfig;

        $this->magentoFieldList = [
            "fmc_email",
            "fmc_billing_prefix",
            "fmc_billing_first_name",
            "fmc_billing_middle_name",
            "fmc_billing_last_name",
            "fmc_billing_suffix",
            "fmc_billing_company",
            "fmc_billing_street_1",
            "fmc_billing_street_2",
            "fmc_billing_city",
            "fmc_billing_postal_code",
            "fmc_billing_region",
            "fmc_billing_country",
            "fmc_billing_telephone",
            "fmc_billing_fax",
            "fmc_billing_vat",
            "fmc_delivery_prefix",
            "fmc_delivery_first_name",
            "fmc_delivery_middle_name",
            "fmc_delivery_last_name",
            "fmc_delivery_suffix",
            "fmc_delivery_company",
            "fmc_delivery_street_1",
            "fmc_delivery_street_2",
            "fmc_delivery_city",
            "fmc_delivery_postal_code",
            "fmc_delivery_region",
            "fmc_delivery_country",
            "fmc_delivery_telephone",
            "fmc_delivery_fax"];
    }

    protected function getMagentoFieldsForSPCSField(string $spcsField, int $websiteId) : array
    {
        $rc = [];

        foreach ($this->magentoFieldList as $magentoField) {
            $spcsFieldSelected =  $this->scopeConfig->getValue('erp_core/field_mapping/' . $magentoField, \Magento\Store\Model\ScopeInterface::SCOPE_WEBSITE, $websiteId);
            if ($spcsField !== null && $spcsField === $spcsFieldSelected) {
                $rc [] =  $magentoField;
            }
        }

        return $rc;
    }

    protected function addressToFieldIdArray(array $billingAddress, array $shippingAddress) : array
    {
        $address = [];

        $address['fmc_email'] = $billingAddress['email'];

        $address['fmc_billing_prefix'] = $billingAddress['prefix'];
        $address['fmc_billing_first_name'] = $billingAddress['firstname'];
        $address['fmc_billing_middle_name'] = $billingAddress['middlename'];
        $address['fmc_billing_last_name'] = $billingAddress['lastname'];
        $address['fmc_billing_suffix'] = $billingAddress['suffix'];
        $address['fmc_billing_company'] = $billingAddress['company'];
        $billingAddressArray = explode("\n", $billingAddress['street']);
        if (count($billingAddressArray) >= 1) {
            $address['fmc_billing_street_1'] = $billingAddressArray[0];
        }
        if (count($billingAddressArray) >= 2) {
            $address['fmc_billing_street_2'] = $billingAddressArray[1];
        }
        $address['fmc_billing_city'] = $billingAddress['city'];
        $address['fmc_billing_postal_code'] = $billingAddress['postcode'];
        $address['fmc_billing_region'] = $billingAddress['region'];
        $address['fmc_billing_country'] = $billingAddress['country_id'];
        $address['fmc_billing_telephone'] = $billingAddress['telephone'];
        $address['fmc_billing_fax'] = $billingAddress['fax'];
        $address['fmc_billing_vat'] = $billingAddress['vat_id'];

        $address['fmc_delivery_prefix'] = $shippingAddress['prefix'];
        $address['fmc_delivery_first_name'] = $shippingAddress['firstname'];
        $address['fmc_delivery_middle_name'] = $shippingAddress['middlename'];
        $address['fmc_delivery_last_name'] = $shippingAddress['lastname'];
        $address['fmc_delivery_suffix'] = $shippingAddress['suffix'];
        $address['fmc_delivery_company'] = $shippingAddress['company'];
        $shippingAddressArray = explode("\n", $shippingAddress['street']);
        if (count($shippingAddressArray) >= 1) {
            $address['fmc_delivery_street_1'] = $shippingAddressArray[0];
        }
        if (count($shippingAddressArray) >= 2) {
            $address['fmc_delivery_street_2'] = $shippingAddressArray[1];
        }
        $address['fmc_delivery_city'] = $shippingAddress['city'];
        $address['fmc_delivery_postal_code'] = $shippingAddress['postcode'];
        $address['fmc_delivery_region'] = $shippingAddress['region'];
        $address['fmc_delivery_country'] = $shippingAddress['country_id'];
        $address['fmc_delivery_telephone'] = $shippingAddress['telephone'];
        $address['fmc_delivery_fax'] = $shippingAddress['fax'];
        $address['fmc_delivery_vat'] = $shippingAddress['vat_id'];

        return $address;
    }

    public function init(string $orderNumber, array $billingAddress, array $shippingAddress, int $websiteId) : void
    {
        // Param $orderNumber is used by FireCheckout plugin, do not remove
        $this->fieldIdArray = $this->addressToFieldIdArray($billingAddress, $shippingAddress);
        $this->websiteId = $websiteId;
    }

    public function getValueForField(string $spcsField) : string
    {
        $rc = '';
        $fields = $this->getMagentoFieldsForSPCSField($spcsField, $this->websiteId);
        foreach ($fields as $field) {
            if (array_key_exists($field, $this->fieldIdArray)) {
                if (strlen($rc) > 0) {
                    $rc = $rc . ' ';
                }
                $rc = $rc . $this->fieldIdArray[$field];
            }
        }
        return $rc;
    }
}
