<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\VismaSPCS\Helper;

use Magento\Config\Model\ResourceModel\Config\Data\CollectionFactory;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\Encryption\EncryptorInterface;
use Magento\Framework\Serialize\Serializer\Json;

class Settings extends \Ecomero\ErpCore\Helper\Settings
{
    public function __construct(
        Context $context,
        EncryptorInterface $encryptor,
        WriterInterface $configWriter,
        CollectionFactory $configCollectionFactory,
        Json $unserializer
    ) {
        parent::__construct(
            $context,
            $encryptor,
            $configWriter,
            $configCollectionFactory,
            $unserializer
        );
    }

    /* * @return string */
    public function getAPIEndPoint(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT) : ?string
    {
        return $this->scopeConfig->getValue('erp_core/general/api_end_point', $scope);
    }

    /* * @return string */
    public function getAPIKey(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT) : ?string
    {
        $secret = $this->scopeConfig->getValue('erp_core/general/api_key', $scope);
        $secret = $this->encryptor->decrypt($secret);
        return $secret;
    }

    /* * @return string */
    public function getCompany(string $scope = ScopeConfigInterface::SCOPE_TYPE_DEFAULT) : ?string
    {
        return $this->scopeConfig->getValue('erp_core/general/company', $scope);
    }

    /* * @return string */
    public function getArticleTemplate(int $websiteId) : ?string
    {
        return $this->scopeConfig->getValue('erp_core/catalog/article_template', 'website', $websiteId);
    }

    /* * @return string */
    public function getAttributeMapping(int $websiteId) : ?array
    {
        $agent = '';
        $tableConfig =  $this->scopeConfig->getValue('erp_core/catalog/attribute_mapping', 'website', $websiteId);
        if ($tableConfig) {
            $tableConfigResults = $this->unserializer->unserialize($tableConfig);
            if (is_array($tableConfigResults)) {
                return $tableConfigResults;
            }
        }
        return null;
    }

    /* * @return string */
    public function getArticleModifiedDate(int $websiteId) : ?string
    {
        $configCollection = $this->configCollectionFactory->create()
                                                        ->addFieldToSelect('value')
                                                        ->addFieldToFilter('path', 'erp_core/catalog/article_modified')
                                                        ->addFieldToFilter('scope', 'websites')
                                                        ->addFieldToFilter('scope_id', $websiteId);

        foreach ($configCollection->getData() as $setting) {
            return $setting['value'];
        }

        return '';
    }

    /* * @return void */
    public function setArticleModifiedDate(int $websiteId, string $dateString) : void
    {
        $this->configWriter->save(
            'erp_core/catalog/article_modified',
            $dateString,
            'websites',
            $websiteId
        );
    }
}
