<?php declare(strict_types=1);
/**
 *
 *           a88888P8
 *          d8'
 * .d8888b. 88        .d8888b. 88d8b.d8b. .d8888b. .dd888b. .d8888b.
 * 88ooood8 88        88'  `88 88'`88'`88 88ooood8 88'    ` 88'  `88
 * 88.  ... Y8.       88.  .88 88  88  88 88.  ... 88       88.  .88
 * `8888P'   Y88888P8 `88888P' dP  dP  dP `8888P'  dP       `88888P'
 *
 *           Copyright © eComero Management AB, All rights reserved.
 *
 */
namespace Ecomero\VismaSPCS\Test\Unit;

use Ecomero\VismaSPCS\Helper\FieldMapper;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Helper\Context;

class FieldMapperTest extends \PHPUnit\Framework\TestCase
{
    protected $fieldMapperMock;
    protected $scopeConfigMock;
    protected $contextMock;

    public function setUp() : void
    {
        // Core Config Data
        $this->scopeConfigMock = $this->getMockBuilder(ScopeConfigInterface::class)->getMockForAbstractClass();
        $this->scopeConfigMock->expects($this->any())->method('getValue')->will($this->returnValueMap(
            [
                ['erp_core/field_mapping/fmc_email', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_billing_prefix', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_billing_first_name', 'website', 0, 'BILLING_REFERENCE'],
                ['erp_core/field_mapping/fmc_billing_middle_name', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_billing_last_name', 'website', 0, 'BILLING_REFERENCE'],
                ['erp_core/field_mapping/fmc_billing_suffix', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_billing_company', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_billing_street_1', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_billing_street_2', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_billing_city', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_billing_postal_code', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_billing_telephone', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_billing_fax', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_billing_vat', 'website', 0, 'NOT_MAPPED'],

                ['erp_core/field_mapping/fmc_delivery_prefix', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_delivery_first_name', 'website', 0, 'DELIVERY_STREET2'],
                ['erp_core/field_mapping/fmc_delivery_middle_name', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_delivery_last_name', 'website', 0, 'DELIVERY_STREET2'],
                ['erp_core/field_mapping/fmc_delivery_suffix', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_delivery_company', 'website', 0, 'DELIVERY_NAME'],
                ['erp_core/field_mapping/fmc_delivery_street_1', 'website', 0, 'DELIVERY_STREET1'],
                ['erp_core/field_mapping/fmc_delivery_street_2', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_delivery_city', 'website', 0, 'DELIVERY_CITY'],
                ['erp_core/field_mapping/fmc_delivery_postal_code', 'website', 0, 'DELIVERY_POSTAL_CODE'],
                ['erp_core/field_mapping/fmc_delivery_country', 'website', 0, 'DELIVERY_COUNTRY_CODE'],
                ['erp_core/field_mapping/fmc_delivery_telephone', 'website', 0, 'DELIVERY_STREET2'],
                ['erp_core/field_mapping/fmc_delivery_fax', 'website', 0, 'NOT_MAPPED'],
                ['erp_core/field_mapping/fmc_delivery_vat', 'website', 0, 'NOT_MAPPED']
                ]
        ));

        // Context Mock
        $this->contextMock = $this->getMockBuilder(Context::class)->disableOriginalConstructor()->getMock();

        // Curl Helper Mock
        $this->fieldMapperMock = $this->getMockBuilder(FieldMapper::class)->setConstructorArgs([
            'context' => $this->contextMock,
            'scopeConfig' => $this->scopeConfigMock,
        ])->getMock();
    }
    public function testGetValueForField() : void
    {
        $billingAddress['company'] = 'B:company';
        $billingAddress['prefix'] = 'B:prefix';
        $billingAddress['firstname'] = 'B:firstname';
        $billingAddress['middlename'] = 'B:middlename';
        $billingAddress['lastname'] = 'B:lastname';
        $billingAddress['suffix'] = 'B:suffix';
        $billingAddress['street']  = 'B:street';
        $billingAddress['city'] = 'B:city';
        $billingAddress['postcode'] = 'B:postcode';
        $billingAddress['email'] = 'B:email';
        $billingAddress['telephone'] = 'B:telephone';
        $billingAddress['country_id']  = 'B:country';
        $billingAddress['region']  = 'B:region';
        $billingAddress['fax']  = 'B:fax';
        $billingAddress['vat_id']  = 'B:vat';

        $shippingAddress['company'] = 'S:company';
        $shippingAddress['prefix'] = 'S:prefix';
        $shippingAddress['firstname'] = 'S:firstname';
        $shippingAddress['middlename'] = 'S:middlename';
        $shippingAddress['lastname'] = 'S:lastname';
        $shippingAddress['suffix'] = 'S:suffix';
        $shippingAddress['street']  = 'S:street';
        $shippingAddress['city'] = 'S:city';
        $shippingAddress['postcode'] = 'S:postcode';
        $shippingAddress['email'] = 'S:email';
        $shippingAddress['telephone'] = 'S:telephone';
        $shippingAddress['country_id']  = 'S:country';
        $shippingAddress['region']  = 'S:region';
        $shippingAddress['fax']  = 'S:fax';
        $shippingAddress['vat_id']  = 'S:vat';

        $fieldMapper = new FieldMapper($this->contextMock, $this->scopeConfigMock);
        $fieldMapper->init($billingAddress, $shippingAddress, 0);
        $rc = $fieldMapper->getValueForField('BILLING_REFERENCE');
        $this->assertEquals('B:firstname B:lastname', $rc);

        $rc = $fieldMapper->getValueForField('DELIVERY_NAME');
        $this->assertEquals('S:company', $rc);

        $rc = $fieldMapper->getValueForField('DELIVERY_STREET2');
        $this->assertEquals('S:firstname S:lastname S:telephone', $rc);
    }
}
